/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.SignableRequest;
import ai.h2o.com.amazonaws.auth.AWSCredentials;
import ai.h2o.com.amazonaws.auth.AWSSessionCredentials;
import ai.h2o.com.amazonaws.auth.AbstractAWSSigner;
import ai.h2o.com.amazonaws.auth.SigningAlgorithm;
import ai.h2o.com.amazonaws.services.s3.internal.RestUtils;
import java.util.Date;

public class S3QueryStringSigner
extends AbstractAWSSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(String httpVerb, String resourcePath, Date expiration) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        this.expiration = expiration;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(SignableRequest<?> request2, AWSCredentials credentials) throws SdkClientException {
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request2, (AWSSessionCredentials)sanitizedCredentials);
        }
        String expirationInSeconds = Long.toString(this.expiration.getTime() / 1000L);
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request2, expirationInSeconds);
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        request2.addParameter("AWSAccessKeyId", sanitizedCredentials.getAWSAccessKeyId());
        request2.addParameter("Expires", expirationInSeconds);
        request2.addParameter("Signature", signature);
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> request2, AWSSessionCredentials credentials) {
        request2.addParameter("x-amz-security-token", credentials.getSessionToken());
    }
}

