/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal;

import ai.h2o.com.amazonaws.services.s3.model.GetObjectRequest;
import ai.h2o.com.amazonaws.services.s3.model.ObjectMetadata;
import ai.h2o.com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import ai.h2o.com.amazonaws.services.s3.model.PresignedUrlUploadRequest;
import ai.h2o.com.amazonaws.services.s3.model.PutObjectRequest;
import ai.h2o.com.amazonaws.services.s3.model.UploadPartRequest;

public class SkipMd5CheckStrategy {
    public static final String DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY = "ai.h2o.com.amazonaws.services.s3.disableGetObjectMD5Validation";
    public static final String DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY = "ai.h2o.com.amazonaws.services.s3.disablePutObjectMD5Validation";
    public static final SkipMd5CheckStrategy INSTANCE = new SkipMd5CheckStrategy();

    private SkipMd5CheckStrategy() {
    }

    public boolean skipClientSideValidationPerGetResponse(ObjectMetadata metadata) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(metadata);
    }

    public boolean skipClientSideValidationPerPutResponse(ObjectMetadata metadata) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.skipClientSideValidationPerResponse(metadata);
    }

    public boolean skipClientSideValidationPerUploadPartResponse(ObjectMetadata metadata) {
        return this.skipClientSideValidationPerPutResponse(metadata);
    }

    public boolean skipClientSideValidation(GetObjectRequest request2, ObjectMetadata returnedMetadata) {
        return this.skipClientSideValidationPerRequest(request2) || this.skipClientSideValidationPerGetResponse(returnedMetadata);
    }

    public boolean skipClientSideValidation(PresignedUrlDownloadRequest request2, ObjectMetadata returnedMetadata) {
        return this.skipClientSideValidationPerRequest(request2) || this.skipClientSideValidationPerGetResponse(returnedMetadata);
    }

    public boolean skipClientSideValidationPerRequest(PutObjectRequest request2) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.putRequestInvolvesSse(request2) || this.metadataInvolvesSse(request2.getMetadata());
    }

    public boolean skipClientSideValidationPerRequest(UploadPartRequest request2) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request2.getSSECustomerKey() != null;
    }

    public boolean skipServerSideValidation(PutObjectRequest request2) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipServerSideValidation(UploadPartRequest request2) {
        return this.isPutObjectMd5ValidationDisabledByProperty();
    }

    public boolean skipClientSideValidationPerRequest(GetObjectRequest request2) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        if (request2.getRange() != null) {
            return true;
        }
        return request2.getSSECustomerKey() != null;
    }

    public boolean skipClientSideValidationPerRequest(PresignedUrlDownloadRequest request2) {
        if (this.isGetObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return request2.getRange() != null;
    }

    public boolean skipClientSideValidationPerRequest(PresignedUrlUploadRequest request2) {
        if (this.isPutObjectMd5ValidationDisabledByProperty()) {
            return true;
        }
        return this.metadataInvolvesSse(request2.getMetadata());
    }

    private boolean skipClientSideValidationPerResponse(ObjectMetadata metadata) {
        if (metadata == null) {
            return true;
        }
        if (metadata.getETag() == null || SkipMd5CheckStrategy.isMultipartUploadETag(metadata.getETag())) {
            return true;
        }
        return this.metadataInvolvesSse(metadata);
    }

    private boolean isGetObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_GET_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }

    private boolean isPutObjectMd5ValidationDisabledByProperty() {
        return System.getProperty(DISABLE_PUT_OBJECT_MD5_VALIDATION_PROPERTY) != null;
    }

    private boolean metadataInvolvesSse(ObjectMetadata metadata) {
        if (metadata == null) {
            return false;
        }
        return SkipMd5CheckStrategy.containsNonNull(metadata.getSSECustomerAlgorithm(), metadata.getSSECustomerKeyMd5(), metadata.getSSEAwsKmsKeyId());
    }

    private boolean putRequestInvolvesSse(PutObjectRequest request2) {
        return SkipMd5CheckStrategy.containsNonNull(request2.getSSECustomerKey(), request2.getSSEAwsKeyManagementParams());
    }

    private static boolean isMultipartUploadETag(String eTag) {
        return eTag.contains("-");
    }

    private static boolean containsNonNull(Object ... items) {
        for (Object item : items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }
}

