/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal.auth;

import ai.h2o.com.amazonaws.AmazonWebServiceClient;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.auth.RegionAwareSigner;
import ai.h2o.com.amazonaws.auth.ServiceAwareSigner;
import ai.h2o.com.amazonaws.auth.Signer;
import ai.h2o.com.amazonaws.handlers.HandlerContextKey;
import ai.h2o.com.amazonaws.internal.auth.SignerProvider;
import ai.h2o.com.amazonaws.internal.auth.SignerProviderContext;
import ai.h2o.com.amazonaws.regions.EndpointToRegion;
import ai.h2o.com.amazonaws.services.s3.internal.ServiceUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner && !this.isAccessPointUri(uri)) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(EndpointToRegion.guessRegionNameForEndpoint(uri.getHost(), "s3"));
            }
            catch (RuntimeException e2) {
                log.warn((Object)("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region"), (Throwable)e2);
            }
        }
        Request<?> request2 = signerProviderContext.getRequest();
        if (!this.isSignerOverridden() && request2 != null && request2.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null) {
            String signingName = request2.getHandlerContext(HandlerContextKey.SIGNING_NAME);
            if (this.signer instanceof ServiceAwareSigner) {
                ((ServiceAwareSigner)this.signer).setServiceName(signingName);
            }
        }
        return this.signer;
    }

    private boolean isAccessPointUri(URI uri) {
        String str = uri.toASCIIString();
        return str.contains(".s3-accesspoint.") || str.contains(".s3-outposts.") || str.contains(".s3-object-lambda.");
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

