/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal.crypto.keywrap;

import ai.h2o.com.amazonaws.services.s3.internal.crypto.keywrap.CipherProvider;
import ai.h2o.com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import ai.h2o.com.amazonaws.util.Throwables;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;

public final class AesGcmKeyWrapper
implements KeyWrapper {
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final int IV_LENGTH_IN_BYTES = 12;
    private static final int TAG_LENGTH_IN_BYTES = 16;
    private static final int TAG_LENGTH_IN_BITS = 128;
    private final CipherProvider cipherProvider;
    private final SecureRandom secureRandom;
    private final String cekAlgorithm;

    private AesGcmKeyWrapper(Builder b2) {
        this.cipherProvider = this.validateNotNull(b2.cipherProvider, "cipherProvider");
        this.secureRandom = b2.secureRandom;
        this.cekAlgorithm = this.validateNotNull(b2.cekAlgorithm, "cekAlgorithm");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String cipherAlgorithm() {
        return CIPHER_ALGORITHM;
    }

    public CipherProvider cipherProvider() {
        return this.cipherProvider;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String cekAlgorithm() {
        return this.cekAlgorithm;
    }

    @Override
    public byte[] unwrapCek(byte[] encryptedCek, Key key) {
        ByteBuffer encryptedCekBuff = ByteBuffer.wrap(encryptedCek);
        byte[] iv = new byte[12];
        byte[] taggedCek = new byte[encryptedCek.length - 12];
        encryptedCekBuff.get(iv);
        encryptedCekBuff.get(taggedCek);
        Cipher cipher = this.cipherProvider.createCipher();
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        try {
            cipher.init(2, key, gcmParameterSpec);
            cipher.updateAAD(this.cekAlgorithm.getBytes(StandardCharsets.UTF_8));
            return cipher.doFinal(taggedCek);
        }
        catch (Exception e2) {
            throw Throwables.failure(e2, "An exception was thrown when attempting to decrypt the Content Encryption Key");
        }
    }

    @Override
    public byte[] wrapCek(byte[] plaintextCek, Key key) {
        if (this.secureRandom == null) {
            throw new NullPointerException("Error initializing AesGcmKeyWrapper for wrapping: 'secureRandom' cannot be null");
        }
        Cipher cipher = this.cipherProvider.createCipher();
        byte[] iv = new byte[12];
        this.secureRandom.nextBytes(iv);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        try {
            cipher.init(1, key, gcmParameterSpec, this.secureRandom);
            cipher.updateAAD(this.cekAlgorithm.getBytes(StandardCharsets.UTF_8));
            return AesGcmKeyWrapper.concat(cipher.getIV(), cipher.doFinal(plaintextCek));
        }
        catch (Exception e2) {
            throw Throwables.failure(e2, "An exception was thrown when attempting to encrypt the Content Encryption Key");
        }
    }

    private <T> T validateNotNull(T obj, String propertyName) {
        if (obj == null) {
            throw new NullPointerException("Error initializing AesGcmKeyWrapper: '" + propertyName + "' cannot be null");
        }
        return obj;
    }

    private static byte[] concat(byte[] a2, byte[] b2) {
        byte[] c2 = new byte[a2.length + b2.length];
        System.arraycopy(a2, 0, c2, 0, a2.length);
        System.arraycopy(b2, 0, c2, a2.length, b2.length);
        return c2;
    }

    public static final class Builder {
        private CipherProvider cipherProvider;
        private SecureRandom secureRandom;
        private String cekAlgorithm;

        private Builder() {
        }

        public Builder cipherProvider(CipherProvider cipherProvider) {
            this.cipherProvider = cipherProvider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder cekAlgorithm(String cekAlgorithm) {
            this.cekAlgorithm = cekAlgorithm;
            return this;
        }

        public AesGcmKeyWrapper build() {
            return new AesGcmKeyWrapper(this);
        }
    }
}

