/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.transfer.internal;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.services.s3.internal.FileLocks;
import ai.h2o.com.amazonaws.services.s3.transfer.Transfer;
import ai.h2o.com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@SdkInternalApi
public class CompleteMultipartDownload
implements Callable<File> {
    private final List<Future<Long>> partFiles;
    private final File destinationFile;
    private final DownloadImpl download;
    private Integer currentPartNumber;

    public CompleteMultipartDownload(List<Future<Long>> files, File destinationFile, DownloadImpl download, Integer currentPartNumber) {
        this.partFiles = files;
        this.destinationFile = destinationFile;
        this.download = download;
        this.currentPartNumber = currentPartNumber;
    }

    @Override
    public File call() throws Exception {
        try {
            for (Future<Long> file : this.partFiles) {
                long filePosition = file.get();
                Integer n2 = this.currentPartNumber;
                Integer n3 = this.currentPartNumber = Integer.valueOf(this.currentPartNumber + 1);
                this.download.updatePersistableTransfer(n2, filePosition);
            }
            this.download.setState(Transfer.TransferState.Completed);
        }
        catch (Exception exception) {
            this.cleanUpAfterException();
            throw new SdkClientException("Unable to complete multipart download. Individual part download failed.", exception);
        }
        finally {
            FileLocks.unlock(this.destinationFile);
        }
        return this.destinationFile;
    }

    private void cleanUpAfterException() {
        for (Future<Long> file : this.partFiles) {
            file.cancel(false);
        }
        this.download.setState(Transfer.TransferState.Failed);
    }
}

