/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.securitytoken;

import ai.h2o.com.amazonaws.AmazonServiceException;
import ai.h2o.com.amazonaws.AmazonWebServiceClient;
import ai.h2o.com.amazonaws.AmazonWebServiceRequest;
import ai.h2o.com.amazonaws.AmazonWebServiceResponse;
import ai.h2o.com.amazonaws.ClientConfiguration;
import ai.h2o.com.amazonaws.ClientConfigurationFactory;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.Response;
import ai.h2o.com.amazonaws.ResponseMetadata;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.annotation.SdkTestInternalApi;
import ai.h2o.com.amazonaws.annotation.ThreadSafe;
import ai.h2o.com.amazonaws.auth.AWSCredentials;
import ai.h2o.com.amazonaws.auth.AWSCredentialsProvider;
import ai.h2o.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import ai.h2o.com.amazonaws.client.AwsSyncClientParams;
import ai.h2o.com.amazonaws.client.builder.AdvancedConfig;
import ai.h2o.com.amazonaws.handlers.HandlerChainFactory;
import ai.h2o.com.amazonaws.handlers.HandlerContextKey;
import ai.h2o.com.amazonaws.http.DefaultErrorResponseHandler;
import ai.h2o.com.amazonaws.http.ExecutionContext;
import ai.h2o.com.amazonaws.http.HttpResponseHandler;
import ai.h2o.com.amazonaws.http.StaxResponseHandler;
import ai.h2o.com.amazonaws.internal.StaticCredentialsProvider;
import ai.h2o.com.amazonaws.metrics.RequestMetricCollector;
import ai.h2o.com.amazonaws.regions.Region;
import ai.h2o.com.amazonaws.regions.RegionUtils;
import ai.h2o.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import ai.h2o.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import ai.h2o.com.amazonaws.services.securitytoken.RegionalEndpointsOptionResolver;
import ai.h2o.com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetAccessKeyInfoRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetAccessKeyInfoResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithSAMLRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithSAMLResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithWebIdentityResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.DecodeAuthorizationMessageRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.DecodeAuthorizationMessageResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.ExpiredTokenExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetAccessKeyInfoRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetAccessKeyInfoResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetCallerIdentityRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetCallerIdentityResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetFederationTokenRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetFederationTokenResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetSessionTokenRequestMarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.GetSessionTokenResultStaxUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.IDPCommunicationErrorExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.IDPRejectedClaimExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.InvalidIdentityTokenExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import ai.h2o.com.amazonaws.services.securitytoken.model.transform.RegionDisabledExceptionUnmarshaller;
import ai.h2o.com.amazonaws.transform.StandardErrorUnmarshaller;
import ai.h2o.com.amazonaws.transform.Unmarshaller;
import ai.h2o.com.amazonaws.util.AWSRequestMetrics;
import ai.h2o.com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AWSSecurityTokenServiceClient
extends AmazonWebServiceClient
implements AWSSecurityTokenService {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSecurityTokenService.class);
    private static final String DEFAULT_SIGNING_NAME = "sts";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private static final Set<String> LEGACY_ENABLED_REGIONS;
    private static RegionalEndpointsOptionResolver REGIONAL_ENDPOINTS_OPTION_RESOLVER;

    @Deprecated
    public AWSSecurityTokenServiceClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSSecurityTokenServiceClientBuilder builder() {
        return AWSSecurityTokenServiceClientBuilder.standard();
    }

    AWSSecurityTokenServiceClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSecurityTokenServiceClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidAuthorizationMessageExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ExpiredTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PackedPolicyTooLargeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RegionDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedPolicyDocumentExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IDPCommunicationErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidIdentityTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IDPRejectedClaimExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller(AWSSecurityTokenServiceException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sts.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/ai/h2o/com/amazonaws/services/securitytoken/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/ai/h2o/com/amazonaws/services/securitytoken/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssumeRoleResult assumeRole(AssumeRoleRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeAssumeRole(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleResult executeAssumeRole(AssumeRoleRequest assumeRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new AssumeRoleRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssumeRole");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleResult> responseHandler = new StaxResponseHandler<AssumeRoleResult>(new AssumeRoleResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            AssumeRoleResult assumeRoleResult = (AssumeRoleResult)response.getAwsResponse();
            return assumeRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public AssumeRoleWithSAMLResult assumeRoleWithSAML(AssumeRoleWithSAMLRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeAssumeRoleWithSAML(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleWithSAMLResult executeAssumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleWithSAMLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleWithSAMLRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new AssumeRoleWithSAMLRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleWithSAMLRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssumeRoleWithSAML");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleWithSAMLResult> responseHandler = new StaxResponseHandler<AssumeRoleWithSAMLResult>(new AssumeRoleWithSAMLResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            AssumeRoleWithSAMLResult assumeRoleWithSAMLResult = (AssumeRoleWithSAMLResult)response.getAwsResponse();
            return assumeRoleWithSAMLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeAssumeRoleWithWebIdentity(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleWithWebIdentityResult executeAssumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleWithWebIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleWithWebIdentityRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new AssumeRoleWithWebIdentityRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleWithWebIdentityRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssumeRoleWithWebIdentity");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleWithWebIdentityResult> responseHandler = new StaxResponseHandler<AssumeRoleWithWebIdentityResult>(new AssumeRoleWithWebIdentityResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult = (AssumeRoleWithWebIdentityResult)response.getAwsResponse();
            return assumeRoleWithWebIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public DecodeAuthorizationMessageResult decodeAuthorizationMessage(DecodeAuthorizationMessageRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeDecodeAuthorizationMessage(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecodeAuthorizationMessageResult executeDecodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decodeAuthorizationMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecodeAuthorizationMessageRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new DecodeAuthorizationMessageRequestMarshaller().marshall(super.beforeMarshalling(decodeAuthorizationMessageRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DecodeAuthorizationMessage");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DecodeAuthorizationMessageResult> responseHandler = new StaxResponseHandler<DecodeAuthorizationMessageResult>(new DecodeAuthorizationMessageResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            DecodeAuthorizationMessageResult decodeAuthorizationMessageResult = (DecodeAuthorizationMessageResult)response.getAwsResponse();
            return decodeAuthorizationMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public GetAccessKeyInfoResult getAccessKeyInfo(GetAccessKeyInfoRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeGetAccessKeyInfo(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccessKeyInfoResult executeGetAccessKeyInfo(GetAccessKeyInfoRequest getAccessKeyInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccessKeyInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccessKeyInfoRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new GetAccessKeyInfoRequestMarshaller().marshall(super.beforeMarshalling(getAccessKeyInfoRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetAccessKeyInfo");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetAccessKeyInfoResult> responseHandler = new StaxResponseHandler<GetAccessKeyInfoResult>(new GetAccessKeyInfoResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            GetAccessKeyInfoResult getAccessKeyInfoResult = (GetAccessKeyInfoResult)response.getAwsResponse();
            return getAccessKeyInfoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public GetCallerIdentityResult getCallerIdentity(GetCallerIdentityRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeGetCallerIdentity(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCallerIdentityResult executeGetCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCallerIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCallerIdentityRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new GetCallerIdentityRequestMarshaller().marshall(super.beforeMarshalling(getCallerIdentityRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetCallerIdentity");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetCallerIdentityResult> responseHandler = new StaxResponseHandler<GetCallerIdentityResult>(new GetCallerIdentityResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            GetCallerIdentityResult getCallerIdentityResult = (GetCallerIdentityResult)response.getAwsResponse();
            return getCallerIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public GetFederationTokenResult getFederationToken(GetFederationTokenRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeGetFederationToken(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFederationTokenResult executeGetFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFederationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFederationTokenRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new GetFederationTokenRequestMarshaller().marshall(super.beforeMarshalling(getFederationTokenRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetFederationToken");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetFederationTokenResult> responseHandler = new StaxResponseHandler<GetFederationTokenResult>(new GetFederationTokenResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            GetFederationTokenResult getFederationTokenResult = (GetFederationTokenResult)response.getAwsResponse();
            return getFederationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public GetSessionTokenResult getSessionToken(GetSessionTokenRequest request2) {
        request2 = this.beforeClientExecution(request2);
        return this.executeGetSessionToken(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSessionTokenResult executeGetSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSessionTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSessionTokenRequest> request2 = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request2 = new GetSessionTokenRequestMarshaller().marshall(super.beforeMarshalling(getSessionTokenRequest));
                request2.setAWSRequestMetrics(awsRequestMetrics);
                request2.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request2.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request2.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request2.addHandlerContext(HandlerContextKey.SERVICE_ID, "STS");
                request2.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetSessionToken");
                request2.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetSessionTokenResult> responseHandler = new StaxResponseHandler<GetSessionTokenResult>(new GetSessionTokenResultStaxUnmarshaller());
            response = this.invoke(request2, responseHandler, executionContext);
            GetSessionTokenResult getSessionTokenResult = (GetSessionTokenResult)response.getAwsResponse();
            return getSessionTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request2, response);
        }
    }

    @Override
    public GetSessionTokenResult getSessionToken() {
        return this.getSessionToken(new GetSessionTokenRequest());
    }

    @Override
    @Deprecated
    public void setRegion(Region region) {
        Region mappedRegion = this.mapToLegacyRegionIfNecessary(region);
        super.setRegion(mappedRegion);
    }

    private Region mapToLegacyRegionIfNecessary(Region region) {
        if (this.legacyRegionModeEnabled() && LEGACY_ENABLED_REGIONS.contains(region.getName())) {
            return RegionUtils.getRegion("aws-global");
        }
        return region;
    }

    private boolean legacyRegionModeEnabled() {
        return REGIONAL_ENDPOINTS_OPTION_RESOLVER.useLegacyMode();
    }

    @SdkTestInternalApi
    static void setRegionalEndpointsOptionResolver(RegionalEndpointsOptionResolver resolver) {
        REGIONAL_ENDPOINTS_OPTION_RESOLVER = resolver;
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request2) {
        return this.client.getResponseMetadataForRequest(request2);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request2, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request2, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request2, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request2.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request2, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request2, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request2, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request2, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request2.setEndpoint(discoveredEndpoint);
            request2.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request2.setEndpoint(uriFromEndpointTrait);
        } else {
            request2.setEndpoint(this.endpoint);
        }
        request2.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request2, responseHandler, errorResponseHandler, executionContext);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    static {
        HashSet<String> legacyEnabledRegions = new HashSet<String>();
        legacyEnabledRegions.add("ap-northeast-1");
        legacyEnabledRegions.add("ap-south-1");
        legacyEnabledRegions.add("ap-southeast-1");
        legacyEnabledRegions.add("ap-southeast-2");
        legacyEnabledRegions.add("aws-global");
        legacyEnabledRegions.add("ca-central-1");
        legacyEnabledRegions.add("eu-central-1");
        legacyEnabledRegions.add("eu-north-1");
        legacyEnabledRegions.add("eu-west-1");
        legacyEnabledRegions.add("eu-west-2");
        legacyEnabledRegions.add("eu-west-3");
        legacyEnabledRegions.add("sa-east-1");
        legacyEnabledRegions.add("us-east-1");
        legacyEnabledRegions.add("us-east-2");
        legacyEnabledRegions.add("us-west-1");
        legacyEnabledRegions.add("us-west-2");
        LEGACY_ENABLED_REGIONS = Collections.unmodifiableSet(legacyEnabledRegions);
        REGIONAL_ENDPOINTS_OPTION_RESOLVER = new RegionalEndpointsOptionResolver();
    }
}

