/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.securitytoken.model.transform;

import ai.h2o.com.amazonaws.DefaultRequest;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.http.HttpMethodName;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import ai.h2o.com.amazonaws.services.securitytoken.model.Tag;
import ai.h2o.com.amazonaws.transform.Marshaller;
import ai.h2o.com.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    @Override
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        if (assumeRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssumeRoleRequest> request2 = new DefaultRequest<AssumeRoleRequest>(assumeRoleRequest, "AWSSecurityTokenService");
        request2.addParameter("Action", "AssumeRole");
        request2.addParameter("Version", "2011-06-15");
        request2.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleRequest.getRoleArn() != null) {
            request2.addParameter("RoleArn", StringUtils.fromString(assumeRoleRequest.getRoleArn()));
        }
        if (assumeRoleRequest.getRoleSessionName() != null) {
            request2.addParameter("RoleSessionName", StringUtils.fromString(assumeRoleRequest.getRoleSessionName()));
        }
        if (assumeRoleRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = assumeRoleRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request2.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue != null && policyArnsListValue.getArn() != null) {
                        request2.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString(policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (assumeRoleRequest.getPolicy() != null) {
            request2.addParameter("Policy", StringUtils.fromString(assumeRoleRequest.getPolicy()));
        }
        if (assumeRoleRequest.getDurationSeconds() != null) {
            request2.addParameter("DurationSeconds", StringUtils.fromInteger(assumeRoleRequest.getDurationSeconds()));
        }
        if (assumeRoleRequest.getTags() != null) {
            List<Tag> tagsList = assumeRoleRequest.getTags();
            if (tagsList.isEmpty()) {
                request2.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request2.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request2.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (assumeRoleRequest.getTransitiveTagKeys() != null) {
            List<String> transitiveTagKeysList = assumeRoleRequest.getTransitiveTagKeys();
            if (transitiveTagKeysList.isEmpty()) {
                request2.addParameter("TransitiveTagKeys", "");
            } else {
                int transitiveTagKeysListIndex = 1;
                for (String transitiveTagKeysListValue : transitiveTagKeysList) {
                    if (transitiveTagKeysListValue != null) {
                        request2.addParameter("TransitiveTagKeys.member." + transitiveTagKeysListIndex, StringUtils.fromString(transitiveTagKeysListValue));
                    }
                    ++transitiveTagKeysListIndex;
                }
            }
        }
        if (assumeRoleRequest.getExternalId() != null) {
            request2.addParameter("ExternalId", StringUtils.fromString(assumeRoleRequest.getExternalId()));
        }
        if (assumeRoleRequest.getSerialNumber() != null) {
            request2.addParameter("SerialNumber", StringUtils.fromString(assumeRoleRequest.getSerialNumber()));
        }
        if (assumeRoleRequest.getTokenCode() != null) {
            request2.addParameter("TokenCode", StringUtils.fromString(assumeRoleRequest.getTokenCode()));
        }
        if (assumeRoleRequest.getSourceIdentity() != null) {
            request2.addParameter("SourceIdentity", StringUtils.fromString(assumeRoleRequest.getSourceIdentity()));
        }
        return request2;
    }
}

