/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.securitytoken.model.transform;

import ai.h2o.com.amazonaws.DefaultRequest;
import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.http.HttpMethodName;
import ai.h2o.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import ai.h2o.com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import ai.h2o.com.amazonaws.transform.Marshaller;
import ai.h2o.com.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleWithSAMLRequestMarshaller
implements Marshaller<Request<AssumeRoleWithSAMLRequest>, AssumeRoleWithSAMLRequest> {
    @Override
    public Request<AssumeRoleWithSAMLRequest> marshall(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        if (assumeRoleWithSAMLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssumeRoleWithSAMLRequest> request2 = new DefaultRequest<AssumeRoleWithSAMLRequest>(assumeRoleWithSAMLRequest, "AWSSecurityTokenService");
        request2.addParameter("Action", "AssumeRoleWithSAML");
        request2.addParameter("Version", "2011-06-15");
        request2.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleWithSAMLRequest.getRoleArn() != null) {
            request2.addParameter("RoleArn", StringUtils.fromString(assumeRoleWithSAMLRequest.getRoleArn()));
        }
        if (assumeRoleWithSAMLRequest.getPrincipalArn() != null) {
            request2.addParameter("PrincipalArn", StringUtils.fromString(assumeRoleWithSAMLRequest.getPrincipalArn()));
        }
        if (assumeRoleWithSAMLRequest.getSAMLAssertion() != null) {
            request2.addParameter("SAMLAssertion", StringUtils.fromString(assumeRoleWithSAMLRequest.getSAMLAssertion()));
        }
        if (assumeRoleWithSAMLRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = assumeRoleWithSAMLRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request2.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue != null && policyArnsListValue.getArn() != null) {
                        request2.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString(policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (assumeRoleWithSAMLRequest.getPolicy() != null) {
            request2.addParameter("Policy", StringUtils.fromString(assumeRoleWithSAMLRequest.getPolicy()));
        }
        if (assumeRoleWithSAMLRequest.getDurationSeconds() != null) {
            request2.addParameter("DurationSeconds", StringUtils.fromInteger(assumeRoleWithSAMLRequest.getDurationSeconds()));
        }
        return request2;
    }
}

