/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.util;

import ai.h2o.com.amazonaws.annotation.NotThreadSafe;
import ai.h2o.com.amazonaws.util.TimingInfoFullSupport;
import ai.h2o.com.amazonaws.util.TimingInfoUnmodifiable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@NotThreadSafe
public class TimingInfo {
    static final int UNKNOWN = -1;
    private final Long startEpochTimeMilli;
    private final long startTimeNano;
    private Long endTimeNano;

    public static TimingInfo startTiming() {
        return new TimingInfo(System.currentTimeMillis(), System.nanoTime(), null);
    }

    public static TimingInfo startTimingFullSupport() {
        return new TimingInfoFullSupport(System.currentTimeMillis(), System.nanoTime(), null);
    }

    public static TimingInfo startTimingFullSupport(long startTimeNano) {
        return new TimingInfoFullSupport(null, startTimeNano, null);
    }

    public static TimingInfo startTimingFullSupport(long startTimeMillis, long startTimeNano) {
        return new TimingInfoFullSupport(startTimeMillis, startTimeNano, null);
    }

    public static TimingInfo newTimingInfoFullSupport(long startTimeNano, long endTimeNano) {
        return new TimingInfoFullSupport(null, startTimeNano, endTimeNano);
    }

    public static TimingInfo newTimingInfoFullSupport(long startEpochTimeMilli, long startTimeNano, long endTimeNano) {
        return new TimingInfoFullSupport(startEpochTimeMilli, startTimeNano, endTimeNano);
    }

    public static TimingInfo unmodifiableTimingInfo(long startTimeNano, Long endTimeNano) {
        return new TimingInfoUnmodifiable(null, startTimeNano, endTimeNano);
    }

    public static TimingInfo unmodifiableTimingInfo(long startEpochTimeMilli, long startTimeNano, Long endTimeNano) {
        return new TimingInfoUnmodifiable(startEpochTimeMilli, startTimeNano, endTimeNano);
    }

    protected TimingInfo(Long startEpochTimeMilli, long startTimeNano, Long endTimeNano) {
        this.startEpochTimeMilli = startEpochTimeMilli;
        this.startTimeNano = startTimeNano;
        this.endTimeNano = endTimeNano;
    }

    @Deprecated
    public final long getStartTime() {
        return this.isStartEpochTimeMilliKnown() ? this.startEpochTimeMilli.longValue() : TimeUnit.NANOSECONDS.toMillis(this.startTimeNano);
    }

    @Deprecated
    public final long getStartEpochTimeMilli() {
        Long v2 = this.getStartEpochTimeMilliIfKnown();
        return v2 == null ? -1L : v2;
    }

    public final Long getStartEpochTimeMilliIfKnown() {
        return this.startEpochTimeMilli;
    }

    public final long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Deprecated
    public final long getEndTime() {
        return this.getEndEpochTimeMilli();
    }

    @Deprecated
    public final long getEndEpochTimeMilli() {
        Long v2 = this.getEndEpochTimeMilliIfKnown();
        return v2 == null ? -1L : v2;
    }

    public final Long getEndEpochTimeMilliIfKnown() {
        return this.isStartEpochTimeMilliKnown() && this.isEndTimeKnown() ? Long.valueOf(this.startEpochTimeMilli + TimeUnit.NANOSECONDS.toMillis(this.endTimeNano - this.startTimeNano)) : null;
    }

    public final long getEndTimeNano() {
        return this.endTimeNano == null ? -1L : this.endTimeNano;
    }

    public final Long getEndTimeNanoIfKnown() {
        return this.endTimeNano;
    }

    @Deprecated
    public final double getTimeTakenMillis() {
        Double v2 = this.getTimeTakenMillisIfKnown();
        return v2 == null ? -1.0 : v2;
    }

    public final Double getTimeTakenMillisIfKnown() {
        return this.isEndTimeKnown() ? Double.valueOf(TimingInfo.durationMilliOf(this.startTimeNano, this.endTimeNano)) : null;
    }

    public static double durationMilliOf(long startTimeNano, long endTimeNano) {
        double micros = TimeUnit.NANOSECONDS.toMicros(endTimeNano - startTimeNano);
        return micros / 1000.0;
    }

    @Deprecated
    public final long getElapsedTimeMillis() {
        Double v2 = this.getTimeTakenMillisIfKnown();
        return v2 == null ? -1L : v2.longValue();
    }

    public final boolean isEndTimeKnown() {
        return this.endTimeNano != null;
    }

    public final boolean isStartEpochTimeMilliKnown() {
        return this.startEpochTimeMilli != null;
    }

    public final String toString() {
        return String.valueOf(this.getTimeTakenMillis());
    }

    @Deprecated
    public void setEndTime(long endTimeMilli) {
        this.endTimeNano = TimeUnit.MILLISECONDS.toNanos(endTimeMilli);
    }

    public void setEndTimeNano(long endTimeNano) {
        this.endTimeNano = endTimeNano;
    }

    public TimingInfo endTiming() {
        this.endTimeNano = System.nanoTime();
        return this;
    }

    public void addSubMeasurement(String subMeasurementName, TimingInfo timingInfo) {
    }

    public TimingInfo getSubMeasurement(String subMeasurementName) {
        return null;
    }

    public TimingInfo getSubMeasurement(String subMesurementName, int index) {
        return null;
    }

    public TimingInfo getLastSubMeasurement(String subMeasurementName) {
        return null;
    }

    public List<TimingInfo> getAllSubMeasurements(String subMeasurementName) {
        return null;
    }

    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return Collections.emptyMap();
    }

    public Number getCounter(String key) {
        return null;
    }

    public Map<String, Number> getAllCounters() {
        return Collections.emptyMap();
    }

    public void setCounter(String key, long count2) {
    }

    public void incrementCounter(String key) {
    }
}

