/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.util;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.util.Base64;
import ai.h2o.com.amazonaws.util.BinaryUtils;
import ai.h2o.com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Stack;

public class XMLWriter {
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final Writer writer;
    private final String xmlns;
    private Stack<String> elementStack = new Stack();
    private boolean rootElement = true;

    public XMLWriter(Writer w2) {
        this(w2, null);
    }

    public XMLWriter(Writer w2, String xmlns) {
        this.writer = w2;
        this.xmlns = xmlns;
        this.append(PROLOG);
    }

    public XMLWriter startElement(String element) {
        this.append("<" + element);
        if (this.rootElement && this.xmlns != null) {
            this.append(" xmlns=\"" + this.xmlns + "\"");
            this.rootElement = false;
        }
        this.append(">");
        this.elementStack.push(element);
        return this;
    }

    public XMLWriter endElement() {
        String lastElement = this.elementStack.pop();
        this.append("</" + lastElement + ">");
        return this;
    }

    public XMLWriter value(String s2) {
        this.append(this.escapeXMLEntities(s2));
        return this;
    }

    public XMLWriter value(ByteBuffer b2) {
        this.append(this.escapeXMLEntities(Base64.encodeAsString(BinaryUtils.copyBytesFrom(b2))));
        return this;
    }

    public XMLWriter value(Date date) {
        this.append(this.escapeXMLEntities(StringUtils.fromDate(date)));
        return this;
    }

    public XMLWriter value(Object obj) {
        this.append(this.escapeXMLEntities(obj.toString()));
        return this;
    }

    private void append(String s2) {
        try {
            this.writer.append(s2);
        }
        catch (IOException e2) {
            throw new SdkClientException("Unable to write XML document", e2);
        }
    }

    private String escapeXMLEntities(String s2) {
        if (s2.contains("&")) {
            s2 = s2.replace("&quot;", "\"");
            s2 = s2.replace("&apos;", "'");
            s2 = s2.replace("&lt;", "<");
            s2 = s2.replace("&gt;", ">");
            s2 = s2.replace("&amp;", "&");
        }
        s2 = s2.replace("&", "&amp;");
        s2 = s2.replace("\"", "&quot;");
        s2 = s2.replace("'", "&apos;");
        s2 = s2.replace("<", "&lt;");
        s2 = s2.replace(">", "&gt;");
        return s2;
    }
}

