/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.waiters;

import ai.h2o.com.amazonaws.AmazonServiceException;
import ai.h2o.com.amazonaws.AmazonWebServiceRequest;
import ai.h2o.com.amazonaws.annotation.SdkProtectedApi;
import ai.h2o.com.amazonaws.util.ValidationUtils;
import ai.h2o.com.amazonaws.waiters.PollingStrategy;
import ai.h2o.com.amazonaws.waiters.SdkFunction;
import ai.h2o.com.amazonaws.waiters.Waiter;
import ai.h2o.com.amazonaws.waiters.WaiterAcceptor;
import ai.h2o.com.amazonaws.waiters.WaiterBuilder;
import ai.h2o.com.amazonaws.waiters.WaiterExecution;
import ai.h2o.com.amazonaws.waiters.WaiterExecutionBuilder;
import ai.h2o.com.amazonaws.waiters.WaiterHandler;
import ai.h2o.com.amazonaws.waiters.WaiterParameters;
import ai.h2o.com.amazonaws.waiters.WaiterTimedOutException;
import ai.h2o.com.amazonaws.waiters.WaiterUnrecoverableException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@SdkProtectedApi
public class WaiterImpl<Input extends AmazonWebServiceRequest, Output>
implements Waiter<Input> {
    private final SdkFunction<Input, Output> sdkFunction;
    private final List<WaiterAcceptor<Output>> acceptors;
    private final PollingStrategy defaultPollingStrategy;
    private final ExecutorService executorService;

    @SdkProtectedApi
    public WaiterImpl(WaiterBuilder<Input, Output> waiterBuilder) {
        this.sdkFunction = ValidationUtils.assertNotNull(waiterBuilder.getSdkFunction(), "sdkFunction");
        this.acceptors = ValidationUtils.assertNotNull(waiterBuilder.getAcceptor(), "acceptors");
        this.defaultPollingStrategy = ValidationUtils.assertNotNull(waiterBuilder.getDefaultPollingStrategy(), "defaultPollingStrategy");
        this.executorService = ValidationUtils.assertNotNull(waiterBuilder.getExecutorService(), "executorService");
    }

    @Override
    public void run(WaiterParameters<Input> waiterParameters) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        ValidationUtils.assertNotNull(waiterParameters, "waiterParameters");
        AmazonWebServiceRequest request2 = ((AmazonWebServiceRequest)ValidationUtils.assertNotNull(waiterParameters.getRequest(), "request")).clone();
        request2.getRequestClientOptions().appendUserAgent("waiter-request");
        WaiterExecution waiterExecution = new WaiterExecutionBuilder().withRequest(request2).withPollingStrategy(waiterParameters.getPollingStrategy() != null ? waiterParameters.getPollingStrategy() : this.defaultPollingStrategy).withAcceptors(this.acceptors).withSdkFunction(this.sdkFunction).build();
        waiterExecution.pollResource();
    }

    @Override
    public Future<Void> runAsync(final WaiterParameters<Input> waiterParameters, final WaiterHandler callback) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    WaiterImpl.this.run(waiterParameters);
                    callback.onWaitSuccess(waiterParameters.getRequest());
                }
                catch (Exception ex) {
                    callback.onWaitFailure(ex);
                    throw ex;
                }
                return null;
            }
        });
    }
}

