/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.IterableByteBufferInputStream;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.Parser;
import ai.h2o.com.google.protobuf.UnsafeUtil;
import ai.h2o.com.google.protobuf.Utf8;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class CodedInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_RECURSION_LIMIT = 100;
    private static final int DEFAULT_SIZE_LIMIT = Integer.MAX_VALUE;
    int recursionDepth;
    int recursionLimit = 100;
    int sizeLimit = Integer.MAX_VALUE;
    private boolean shouldDiscardUnknownFields = false;

    public static CodedInputStream newInstance(InputStream input) {
        return CodedInputStream.newInstance(input, 4096);
    }

    public static CodedInputStream newInstance(InputStream input, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be > 0");
        }
        if (input == null) {
            return CodedInputStream.newInstance(Internal.EMPTY_BYTE_ARRAY);
        }
        return new StreamDecoder(input, bufferSize);
    }

    public static CodedInputStream newInstance(Iterable<ByteBuffer> input) {
        if (!UnsafeDirectNioDecoder.isSupported()) {
            return CodedInputStream.newInstance(new IterableByteBufferInputStream(input));
        }
        return CodedInputStream.newInstance(input, false);
    }

    static CodedInputStream newInstance(Iterable<ByteBuffer> bufs, boolean bufferIsImmutable) {
        int n2 = 0;
        int n3 = 0;
        for (ByteBuffer byteBuffer : bufs) {
            n3 += byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                n2 |= 1;
                continue;
            }
            if (byteBuffer.isDirect()) {
                n2 |= 2;
                continue;
            }
            n2 |= 4;
        }
        if (n2 == 2) {
            return new IterableDirectByteBufferDecoder(bufs, n3, bufferIsImmutable);
        }
        return CodedInputStream.newInstance(new IterableByteBufferInputStream(bufs));
    }

    public static CodedInputStream newInstance(byte[] buf) {
        return CodedInputStream.newInstance(buf, 0, buf.length);
    }

    public static CodedInputStream newInstance(byte[] buf, int off, int len) {
        return CodedInputStream.newInstance(buf, off, len, false);
    }

    static CodedInputStream newInstance(byte[] buf, int off, int len, boolean bufferIsImmutable) {
        ArrayDecoder arrayDecoder = new ArrayDecoder(buf, off, len, bufferIsImmutable);
        try {
            arrayDecoder.pushLimit(len);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return arrayDecoder;
    }

    public static CodedInputStream newInstance(ByteBuffer buf) {
        return CodedInputStream.newInstance(buf, false);
    }

    static CodedInputStream newInstance(ByteBuffer buf, boolean bufferIsImmutable) {
        if (buf.hasArray()) {
            return CodedInputStream.newInstance(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining(), bufferIsImmutable);
        }
        if (buf.isDirect() && UnsafeDirectNioDecoder.isSupported()) {
            return new UnsafeDirectNioDecoder(buf, bufferIsImmutable);
        }
        byte[] byArray = new byte[buf.remaining()];
        buf.duplicate().get(byArray);
        return CodedInputStream.newInstance(byArray, 0, byArray.length, true);
    }

    private CodedInputStream() {
    }

    public abstract int readTag() throws IOException;

    public abstract void checkLastTagWas(int var1) throws InvalidProtocolBufferException;

    public abstract int getLastTag();

    public abstract boolean skipField(int var1) throws IOException;

    @Deprecated
    public abstract boolean skipField(int var1, CodedOutputStream var2) throws IOException;

    public abstract void skipMessage() throws IOException;

    public abstract void skipMessage(CodedOutputStream var1) throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract long readUInt64() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readFixed64() throws IOException;

    public abstract int readFixed32() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract String readString() throws IOException;

    public abstract String readStringRequireUtf8() throws IOException;

    public abstract void readGroup(int var1, MessageLite.Builder var2, ExtensionRegistryLite var3) throws IOException;

    public abstract <T extends MessageLite> T readGroup(int var1, Parser<T> var2, ExtensionRegistryLite var3) throws IOException;

    @Deprecated
    public abstract void readUnknownGroup(int var1, MessageLite.Builder var2) throws IOException;

    public abstract void readMessage(MessageLite.Builder var1, ExtensionRegistryLite var2) throws IOException;

    public abstract <T extends MessageLite> T readMessage(Parser<T> var1, ExtensionRegistryLite var2) throws IOException;

    public abstract ByteString readBytes() throws IOException;

    public abstract byte[] readByteArray() throws IOException;

    public abstract ByteBuffer readByteBuffer() throws IOException;

    public abstract int readUInt32() throws IOException;

    public abstract int readEnum() throws IOException;

    public abstract int readSFixed32() throws IOException;

    public abstract long readSFixed64() throws IOException;

    public abstract int readSInt32() throws IOException;

    public abstract long readSInt64() throws IOException;

    public abstract int readRawVarint32() throws IOException;

    public abstract long readRawVarint64() throws IOException;

    abstract long readRawVarint64SlowPath() throws IOException;

    public abstract int readRawLittleEndian32() throws IOException;

    public abstract long readRawLittleEndian64() throws IOException;

    public abstract void enableAliasing(boolean var1);

    public final int setRecursionLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + limit);
        }
        int n2 = this.recursionLimit;
        this.recursionLimit = limit;
        return n2;
    }

    public final int setSizeLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + limit);
        }
        int n2 = this.sizeLimit;
        this.sizeLimit = limit;
        return n2;
    }

    final void discardUnknownFields() {
        this.shouldDiscardUnknownFields = true;
    }

    final void unsetDiscardUnknownFields() {
        this.shouldDiscardUnknownFields = false;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public abstract void resetSizeCounter();

    public abstract int pushLimit(int var1) throws InvalidProtocolBufferException;

    public abstract void popLimit(int var1);

    public abstract int getBytesUntilLimit();

    public abstract boolean isAtEnd() throws IOException;

    public abstract int getTotalBytesRead();

    public abstract byte readRawByte() throws IOException;

    public abstract byte[] readRawBytes(int var1) throws IOException;

    public abstract void skipRawBytes(int var1) throws IOException;

    public static int decodeZigZag32(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long n2) {
        return n2 >>> 1 ^ -(n2 & 1L);
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int n2;
        int n3;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int n4 = firstByte & 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = input.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n4 |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n4;
        }
        while (n3 < 64) {
            n2 = input.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 & 0x80) == 0) {
                return n4;
            }
            n3 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    static int readRawVarint32(InputStream input) throws IOException {
        int n2 = input.read();
        if (n2 == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n2, input);
    }

    private static final class IterableDirectByteBufferDecoder
    extends CodedInputStream {
        private Iterable<ByteBuffer> input;
        private Iterator<ByteBuffer> iterator;
        private ByteBuffer currentByteBuffer;
        private boolean immutable;
        private boolean enableAliasing;
        private int totalBufferSize;
        private int bufferSizeAfterCurrentLimit;
        private int currentLimit = Integer.MAX_VALUE;
        private int lastTag;
        private int totalBytesRead;
        private int startOffset;
        private long currentByteBufferPos;
        private long currentByteBufferStartPos;
        private long currentAddress;
        private long currentByteBufferLimit;

        private IterableDirectByteBufferDecoder(Iterable<ByteBuffer> inputBufs, int size, boolean immutableFlag) {
            this.totalBufferSize = size;
            this.input = inputBufs;
            this.iterator = this.input.iterator();
            this.immutable = immutableFlag;
            IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
            iterableDirectByteBufferDecoder.totalBytesRead = 0;
            iterableDirectByteBufferDecoder.startOffset = 0;
            if (size == 0) {
                this.currentByteBuffer = Internal.EMPTY_BYTE_BUFFER;
                this.currentByteBufferPos = 0L;
                this.currentByteBufferStartPos = 0L;
                this.currentByteBufferLimit = 0L;
                this.currentAddress = 0L;
                return;
            }
            this.tryGetNextByteBuffer();
        }

        private void getNextByteBuffer() throws InvalidProtocolBufferException {
            if (!this.iterator.hasNext()) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.tryGetNextByteBuffer();
        }

        private void tryGetNextByteBuffer() {
            this.currentByteBuffer = this.iterator.next();
            this.totalBytesRead += (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
            this.currentByteBufferStartPos = this.currentByteBufferPos = (long)this.currentByteBuffer.position();
            this.currentByteBufferLimit = this.currentByteBuffer.limit();
            this.currentAddress = UnsafeUtil.addressOffset(this.currentByteBuffer);
            this.currentByteBufferPos += this.currentAddress;
            this.currentByteBufferStartPos += this.currentAddress;
            this.currentByteBufferLimit += this.currentAddress;
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            if (this.lastTag != value) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public final int getLastTag() {
            return this.lastTag;
        }

        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
                    iterableDirectByteBufferDecoder.skipRawBytes(iterableDirectByteBufferDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final boolean skipField(int tag, CodedOutputStream output) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    long l2 = this.readInt64();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    output.writeRawVarint32(tag);
                    this.skipMessage(output);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                    this.checkLastTagWas(n2);
                    output.writeRawVarint32(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final void skipMessage() throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public final void skipMessage(CodedOutputStream output) throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, output)) {
            }
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public final String readString() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                String string = new String(byArray, Internal.UTF_8);
                this.currentByteBufferPos += (long)n2;
                return string;
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                String string = new String(byArray, Internal.UTF_8);
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                int n3 = (int)(this.currentByteBufferPos - this.currentByteBufferStartPos);
                String string = Utf8.decodeUtf8(this.currentByteBuffer, n3, n2);
                this.currentByteBufferPos += (long)n2;
                return string;
            }
            if (n2 >= 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return Utf8.decodeUtf8(byArray, 0, n2);
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
        }

        @Override
        public final <T extends MessageLite> T readGroup(int fieldNumber, Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public final void readUnknownGroup(int fieldNumber, MessageLite.Builder builder) throws IOException {
            this.readGroup(fieldNumber, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public final ByteString readBytes() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentByteBufferLimit - this.currentByteBufferPos) {
                if (this.immutable && this.enableAliasing) {
                    int n3;
                    int n4 = n3 = (int)(this.currentByteBufferPos - this.currentAddress);
                    ByteString byteString = ByteString.wrap(this.slice(n4, n4 + n2));
                    this.currentByteBufferPos += (long)n2;
                    return byteString;
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                this.currentByteBufferPos += (long)n2;
                return ByteString.wrap(byArray);
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return ByteString.wrap(byArray);
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final byte[] readByteArray() throws IOException {
            IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
            return iterableDirectByteBufferDecoder.readRawBytes(iterableDirectByteBufferDecoder.readRawVarint32());
        }

        @Override
        public final ByteBuffer readByteBuffer() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && (long)n2 <= this.currentRemaining()) {
                if (!this.immutable && this.enableAliasing) {
                    this.currentByteBufferPos += (long)n2;
                    IterableDirectByteBufferDecoder iterableDirectByteBufferDecoder = this;
                    return iterableDirectByteBufferDecoder.slice((int)(iterableDirectByteBufferDecoder.currentByteBufferPos - this.currentAddress - (long)n2), (int)(this.currentByteBufferPos - this.currentAddress));
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)n2);
                this.currentByteBufferPos += (long)n2;
                return ByteBuffer.wrap(byArray);
            }
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                this.readRawBytesTo(byArray, 0, n2);
                return ByteBuffer.wrap(byArray);
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return IterableDirectByteBufferDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                int n2;
                long l2;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l2 = this.currentByteBufferPos;
                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                if ((n2 = UnsafeUtil.getByte(l2++)) >= 0) {
                                    ++this.currentByteBufferPos;
                                    return n2;
                                }
                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                if ((n2 ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = UnsafeUtil.getByte(l2++);
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0) break block4;
                }
                this.currentByteBufferPos = l2;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        @Override
        public final long readRawVarint64() throws IOException {
            block4: {
                long l2;
                long l3;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l3 = this.currentByteBufferPos;
                                                if (this.currentByteBufferLimit == this.currentByteBufferPos) break block4;
                                                if ((n2 = UnsafeUtil.getByte(l3++)) >= 0) {
                                                    ++this.currentByteBufferPos;
                                                    return n2;
                                                }
                                                if (this.currentByteBufferLimit - this.currentByteBufferPos < 10L) break block4;
                                                if ((n2 ^= UnsafeUtil.getByte(l3++) << 7) >= 0) break block5;
                                                l2 = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= UnsafeUtil.getByte(l3++) << 14) < 0) break block7;
                                            l2 = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= UnsafeUtil.getByte(l3++) << 21) >= 0) break block8;
                                        l2 = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n2 ^ (long)UnsafeUtil.getByte(l3++) << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)UnsafeUtil.getByte(l3++) << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l3++) < 0L) break block4;
                }
                this.currentByteBufferPos = l3;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final int readRawLittleEndian32() throws IOException {
            if (this.currentRemaining() >= 4L) {
                long l2 = this.currentByteBufferPos;
                this.currentByteBufferPos += 4L;
                return UnsafeUtil.getByte(l2) & 0xFF | (UnsafeUtil.getByte(l2 + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l2 + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l2 + 3L) & 0xFF) << 24;
            }
            return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
        }

        @Override
        public final long readRawLittleEndian64() throws IOException {
            if (this.currentRemaining() >= 8L) {
                long l2 = this.currentByteBufferPos;
                this.currentByteBufferPos += 8L;
                return (long)UnsafeUtil.getByte(l2) & 0xFFL | ((long)UnsafeUtil.getByte(l2 + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l2 + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l2 + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l2 + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l2 + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l2 + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l2 + 7L) & 0xFFL) << 56;
            }
            return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
        }

        @Override
        public final void enableAliasing(boolean enabled) {
            this.enableAliasing = enabled;
        }

        @Override
        public final void resetSizeCounter() {
            this.startOffset = (int)((long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            int n2;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = byteLimit;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.totalBufferSize += this.bufferSizeAfterCurrentLimit;
            int n2 = this.totalBufferSize - this.startOffset;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterCurrentLimit = n2 - this.currentLimit;
                this.totalBufferSize -= this.bufferSizeAfterCurrentLimit;
                return;
            }
            this.bufferSizeAfterCurrentLimit = 0;
        }

        @Override
        public final void popLimit(int oldLimit) {
            this.currentLimit = oldLimit;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return (long)this.totalBytesRead + this.currentByteBufferPos - this.currentByteBufferStartPos == (long)this.totalBufferSize;
        }

        @Override
        public final int getTotalBytesRead() {
            return (int)((long)(this.totalBytesRead - this.startOffset) + this.currentByteBufferPos - this.currentByteBufferStartPos);
        }

        @Override
        public final byte readRawByte() throws IOException {
            if (this.currentRemaining() == 0L) {
                this.getNextByteBuffer();
            }
            return UnsafeUtil.getByte(this.currentByteBufferPos++);
        }

        @Override
        public final byte[] readRawBytes(int length) throws IOException {
            if (length >= 0 && (long)length <= this.currentRemaining()) {
                byte[] byArray = new byte[length];
                UnsafeUtil.copyMemory(this.currentByteBufferPos, byArray, 0L, (long)length);
                this.currentByteBufferPos += (long)length;
                return byArray;
            }
            if (length >= 0 && length <= this.remaining()) {
                byte[] byArray = new byte[length];
                this.readRawBytesTo(byArray, 0, length);
                return byArray;
            }
            if (length <= 0) {
                if (length == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void readRawBytesTo(byte[] bytes, int offset, int length) throws IOException {
            if (length >= 0 && length <= this.remaining()) {
                int n2 = length;
                while (n2 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n3 = Math.min(n2, (int)this.currentRemaining());
                    UnsafeUtil.copyMemory(this.currentByteBufferPos, bytes, (long)(length - n2 + offset), (long)n3);
                    n2 -= n3;
                    this.currentByteBufferPos += (long)n3;
                }
                return;
            }
            if (length <= 0) {
                if (length == 0) {
                    return;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void skipRawBytes(int length) throws IOException {
            if (length >= 0 && (long)length <= (long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos) {
                int n2 = length;
                while (n2 > 0) {
                    if (this.currentRemaining() == 0L) {
                        this.getNextByteBuffer();
                    }
                    int n3 = Math.min(n2, (int)this.currentRemaining());
                    n2 -= n3;
                    this.currentByteBufferPos += (long)n3;
                }
                return;
            }
            if (length < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void skipRawVarint() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private int remaining() {
            return (int)((long)(this.totalBufferSize - this.totalBytesRead) - this.currentByteBufferPos + this.currentByteBufferStartPos);
        }

        private long currentRemaining() {
            return this.currentByteBufferLimit - this.currentByteBufferPos;
        }

        private ByteBuffer slice(int begin, int end) throws IOException {
            int n2 = this.currentByteBuffer.position();
            int n3 = this.currentByteBuffer.limit();
            try {
                this.currentByteBuffer.position(begin);
                this.currentByteBuffer.limit(end);
                ByteBuffer byteBuffer = this.currentByteBuffer.slice();
                return byteBuffer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            finally {
                this.currentByteBuffer.position(n2);
                this.currentByteBuffer.limit(n3);
            }
        }
    }

    private static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        private StreamDecoder(InputStream input, int bufferSize) {
            Internal.checkNotNull(input, "input");
            this.input = input;
            this.buffer = new byte[bufferSize];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            if (this.lastTag != value) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public final int getLastTag() {
            return this.lastTag;
        }

        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    StreamDecoder streamDecoder = this;
                    streamDecoder.skipRawBytes(streamDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final boolean skipField(int tag, CodedOutputStream output) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    long l2 = this.readInt64();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    output.writeRawVarint32(tag);
                    this.skipMessage(output);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                    this.checkLastTagWas(n2);
                    output.writeRawVarint32(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final void skipMessage() throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public final void skipMessage(CodedOutputStream output) throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, output)) {
            }
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public final String readString() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.bufferSize - this.pos) {
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= this.bufferSize) {
                this.refillBuffer(n2);
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            return new String(this.readRawBytesSlowPath(n2), Internal.UTF_8);
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            int n2;
            byte[] byArray;
            int n3;
            int n4 = this.readRawVarint32();
            if (n4 <= this.bufferSize - (n3 = this.pos) && n4 > 0) {
                byArray = this.buffer;
                this.pos = n3 + n4;
                n2 = n3;
            } else {
                if (n4 == 0) {
                    return "";
                }
                if (n4 <= this.bufferSize) {
                    this.refillBuffer(n4);
                    byArray = this.buffer;
                    n2 = 0;
                    this.pos = n4 + 0;
                } else {
                    byArray = this.readRawBytesSlowPath(n4);
                    n2 = 0;
                }
            }
            return Utf8.decodeUtf8(byArray, n2, n4);
        }

        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
        }

        @Override
        public final <T extends MessageLite> T readGroup(int fieldNumber, Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public final void readUnknownGroup(int fieldNumber, MessageLite.Builder builder) throws IOException {
            this.readGroup(fieldNumber, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public final ByteString readBytes() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                ByteString byteString = ByteString.copyFrom(this.buffer, this.pos, n2);
                this.pos += n2;
                return byteString;
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            return this.readBytesSlowPath(n2);
        }

        @Override
        public final byte[] readByteArray() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                byte[] byArray = Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2);
                this.pos += n2;
                return byArray;
            }
            return this.readRawBytesSlowPath(n2);
        }

        @Override
        public final ByteBuffer readByteBuffer() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 <= this.bufferSize - this.pos && n2 > 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2));
                this.pos += n2;
                return byteBuffer;
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            return ByteBuffer.wrap(this.readRawBytesSlowPath(n2));
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return StreamDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                int n2;
                int n3;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n3 = this.pos;
                                if (this.bufferSize == n3) break block4;
                                byArray = this.buffer;
                                if ((n2 = this.buffer[n3++]) >= 0) {
                                    this.pos = n3;
                                    return n2;
                                }
                                if (this.bufferSize - n3 < 9) break block4;
                                if ((n2 ^= byArray[n3++] << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= byArray[n3++] << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= byArray[n3++] << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = byArray[n3++];
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0) break block4;
                }
                this.pos = n3;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.bufferSize - this.pos >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final long readRawVarint64() throws IOException {
            block4: {
                long l2;
                int n2;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n3;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n2 = this.pos;
                                                if (this.bufferSize == n2) break block4;
                                                byArray = this.buffer;
                                                if ((n3 = this.buffer[n2++]) >= 0) {
                                                    this.pos = n2;
                                                    return n3;
                                                }
                                                if (this.bufferSize - n2 < 9) break block4;
                                                if ((n3 ^= byArray[n2++] << 7) >= 0) break block5;
                                                l2 = n3 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n3 ^= byArray[n2++] << 14) < 0) break block7;
                                            l2 = n3 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n3 ^= byArray[n2++] << 21) >= 0) break block8;
                                        l2 = n3 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n3 ^ (long)byArray[n2++] << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)byArray[n2++] << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)byArray[n2++] << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)byArray[n2++] << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)byArray[n2++] << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) break block4;
                }
                this.pos = n2;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final int readRawLittleEndian32() throws IOException {
            int n2 = this.pos;
            if (this.bufferSize - n2 < 4) {
                this.refillBuffer(4);
                n2 = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        @Override
        public final long readRawLittleEndian64() throws IOException {
            int n2 = this.pos;
            if (this.bufferSize - n2 < 8) {
                this.refillBuffer(8);
                n2 = this.pos;
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        @Override
        public final void enableAliasing(boolean enabled) {
        }

        @Override
        public final void resetSizeCounter() {
            this.totalBytesRetired = -this.pos;
        }

        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.currentLimit;
            if ((byteLimit += this.totalBytesRetired + this.pos) > n2) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = byteLimit;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int n2 = this.totalBytesRetired + this.bufferSize;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        @Override
        public final void popLimit(int oldLimit) {
            this.currentLimit = oldLimit;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            int n2 = this.totalBytesRetired + this.pos;
            return this.currentLimit - n2;
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
        }

        @Override
        public final int getTotalBytesRead() {
            return this.totalBytesRetired + this.pos;
        }

        private void refillBuffer(int n2) throws IOException {
            if (!this.tryRefillBuffer(n2)) {
                if (n2 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private boolean tryRefillBuffer(int n2) throws IOException {
            while (true) {
                int n3;
                int n4;
                if (this.pos + n2 <= this.bufferSize) {
                    throw new IllegalStateException("refillBuffer() called when " + n2 + " bytes were already available in buffer");
                }
                if (n2 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    return false;
                }
                if (this.totalBytesRetired + this.pos + n2 > this.currentLimit) {
                    return false;
                }
                if (this.refillCallback != null) {
                    this.refillCallback.onRefill();
                }
                if ((n4 = this.pos) > 0) {
                    if (this.bufferSize > n4) {
                        System.arraycopy(this.buffer, n4, this.buffer, 0, this.bufferSize - n4);
                    }
                    this.totalBytesRetired += n4;
                    this.bufferSize -= n4;
                    this.pos = 0;
                }
                if ((n3 = this.input.read(this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || n3 < -1 || n3 > this.buffer.length) {
                    throw new IllegalStateException(this.input.getClass() + "#read(byte[]) returned invalid result: " + n3 + "\nThe InputStream implementation is buggy.");
                }
                if (n3 <= 0) break;
                this.bufferSize += n3;
                this.recomputeBufferSizeAfterLimit();
                if (this.bufferSize < n2) continue;
                return true;
            }
            return false;
        }

        @Override
        public final byte readRawByte() throws IOException {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            return this.buffer[this.pos++];
        }

        @Override
        public final byte[] readRawBytes(int size) throws IOException {
            int n2 = this.pos;
            if (size <= this.bufferSize - n2 && size > 0) {
                this.pos = n2 + size;
                int n3 = n2;
                return Arrays.copyOfRange(this.buffer, n3, n3 + size);
            }
            return this.readRawBytesSlowPath(size);
        }

        private byte[] readRawBytesSlowPath(int size) throws IOException {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(size);
            if (byArray != null) {
                return byArray;
            }
            int n2 = this.pos;
            int n3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n4 = size - n3;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
            byte[] byArray2 = new byte[size];
            System.arraycopy(this.buffer, n2, byArray2, 0, n3);
            int n5 = n3;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
                n5 += byArray3.length;
            }
            return byArray2;
        }

        private byte[] readRawBytesSlowPathOneChunk(int size) throws IOException {
            if (size == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int n2 = this.totalBytesRetired + this.pos + size;
            if (n2 - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (n2 > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int n3 = this.bufferSize - this.pos;
            int n4 = size - n3;
            if (n4 < 4096 || n4 <= this.input.available()) {
                int n5;
                byte[] byArray = new byte[size];
                System.arraycopy(this.buffer, this.pos, byArray, 0, n3);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                for (int i2 = n3; i2 < size; i2 += n5) {
                    n5 = this.input.read(byArray, i2, size - i2);
                    if (n5 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n5;
                }
                return byArray;
            }
            return null;
        }

        private List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) throws IOException {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            while (sizeLeft > 0) {
                int n2;
                byte[] byArray = new byte[Math.min(sizeLeft, 4096)];
                for (int i2 = 0; i2 < byArray.length; i2 += n2) {
                    n2 = this.input.read(byArray, i2, byArray.length - i2);
                    if (n2 == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n2;
                }
                sizeLeft -= byArray.length;
                arrayList.add(byArray);
            }
            return arrayList;
        }

        private ByteString readBytesSlowPath(int size) throws IOException {
            byte[] byArray = this.readRawBytesSlowPathOneChunk(size);
            if (byArray != null) {
                return ByteString.wrap(byArray);
            }
            int n2 = this.pos;
            int n3 = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int n4 = size - n3;
            List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>(1 + list.size());
            arrayList.add(ByteString.copyFrom(this.buffer, n2, n3));
            for (byte[] byArray2 : list) {
                arrayList.add(ByteString.wrap(byArray2));
            }
            return ByteString.copyFrom(arrayList);
        }

        @Override
        public final void skipRawBytes(int size) throws IOException {
            if (size <= this.bufferSize - this.pos && size >= 0) {
                this.pos += size;
                return;
            }
            this.skipRawBytesSlowPath(size);
        }

        private void skipRawBytesSlowPath(int size) throws IOException {
            int n2;
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (this.refillCallback != null) {
                int n3 = this.bufferSize - this.pos;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
                while (size - n3 > this.bufferSize) {
                    n3 += this.bufferSize;
                    this.pos = this.bufferSize;
                    this.refillBuffer(1);
                }
                this.pos = size - n3;
                return;
            }
            this.totalBytesRetired += this.pos;
            this.bufferSize = 0;
            this.pos = 0;
            try {
                long l2;
                for (n2 = this.bufferSize - this.pos; n2 < size; n2 += (int)l2) {
                    int n4 = size - n2;
                    l2 = this.input.skip(n4);
                    if (l2 >= 0L && l2 <= (long)n4) continue;
                    throw new IllegalStateException(this.input.getClass() + "#skip returned invalid result: " + l2 + "\nThe InputStream implementation is buggy.");
                }
                return;
            }
            finally {
                this.totalBytesRetired += n2;
                this.recomputeBufferSizeAfterLimit();
            }
        }

        private static interface RefillCallback {
            public void onRefill();
        }

        private class SkippedDataSink
        implements RefillCallback {
            private int lastPos;
            private ByteArrayOutputStream byteArrayStream;

            private SkippedDataSink() {
                this.lastPos = StreamDecoder.this.pos;
            }

            @Override
            public void onRefill() {
                if (this.byteArrayStream == null) {
                    this.byteArrayStream = new ByteArrayOutputStream();
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                this.lastPos = 0;
            }

            ByteBuffer getSkippedData() {
                if (this.byteArrayStream == null) {
                    return ByteBuffer.wrap(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos - this.lastPos);
                }
                this.byteArrayStream.write(StreamDecoder.this.buffer, this.lastPos, StreamDecoder.this.pos);
                return ByteBuffer.wrap(this.byteArrayStream.toByteArray());
            }
        }
    }

    private static final class UnsafeDirectNioDecoder
    extends CodedInputStream {
        private final ByteBuffer buffer;
        private final boolean immutable;
        private final long address;
        private long limit;
        private long pos;
        private long startPos;
        private int bufferSizeAfterLimit;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private UnsafeDirectNioDecoder(ByteBuffer buffer, boolean immutable) {
            this.buffer = buffer;
            this.address = UnsafeUtil.addressOffset(buffer);
            this.limit = this.address + (long)buffer.limit();
            this.startPos = this.pos = this.address + (long)buffer.position();
            this.immutable = immutable;
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            if (this.lastTag != value) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public final int getLastTag() {
            return this.lastTag;
        }

        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                    unsafeDirectNioDecoder.skipRawBytes(unsafeDirectNioDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final boolean skipField(int tag, CodedOutputStream output) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    long l2 = this.readInt64();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    output.writeRawVarint32(tag);
                    this.skipMessage(output);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                    this.checkLastTagWas(n2);
                    output.writeRawVarint32(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final void skipMessage() throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public final void skipMessage(CodedOutputStream output) throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, output)) {
            }
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public final String readString() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                String string = new String(byArray, Internal.UTF_8);
                this.pos += (long)n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                int n3 = unsafeDirectNioDecoder.bufferPos(unsafeDirectNioDecoder.pos);
                String string = Utf8.decodeUtf8(this.buffer, n3, n2);
                this.pos += (long)n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
        }

        @Override
        public final <T extends MessageLite> T readGroup(int fieldNumber, Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public final void readUnknownGroup(int fieldNumber, MessageLite.Builder builder) throws IOException {
            this.readGroup(fieldNumber, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public final ByteString readBytes() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                if (this.immutable && this.enableAliasing) {
                    UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                    ByteBuffer byteBuffer = unsafeDirectNioDecoder.slice(unsafeDirectNioDecoder.pos, this.pos + (long)n2);
                    this.pos += (long)n2;
                    return ByteString.wrap(byteBuffer);
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                this.pos += (long)n2;
                return ByteString.wrap(byArray);
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final byte[] readByteArray() throws IOException {
            UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
            return unsafeDirectNioDecoder.readRawBytes(unsafeDirectNioDecoder.readRawVarint32());
        }

        @Override
        public final ByteBuffer readByteBuffer() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.remaining()) {
                if (!this.immutable && this.enableAliasing) {
                    UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                    ByteBuffer byteBuffer = unsafeDirectNioDecoder.slice(unsafeDirectNioDecoder.pos, this.pos + (long)n2);
                    this.pos += (long)n2;
                    return byteBuffer;
                }
                byte[] byArray = new byte[n2];
                UnsafeUtil.copyMemory(this.pos, byArray, 0L, (long)n2);
                this.pos += (long)n2;
                return ByteBuffer.wrap(byArray);
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return UnsafeDirectNioDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                int n2;
                long l2;
                block6: {
                    block8: {
                        block7: {
                            block5: {
                                l2 = this.pos;
                                if (this.limit == l2) break block4;
                                if ((n2 = UnsafeUtil.getByte(l2++)) >= 0) {
                                    this.pos = l2;
                                    return n2;
                                }
                                if (this.limit - l2 < 9L) break block4;
                                if ((n2 ^= UnsafeUtil.getByte(l2++) << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= UnsafeUtil.getByte(l2++) << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= UnsafeUtil.getByte(l2++) << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = UnsafeUtil.getByte(l2++);
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0 && UnsafeUtil.getByte(l2++) < 0) break block4;
                }
                this.pos = l2;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.remaining() >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (UnsafeUtil.getByte(this.pos++) < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final long readRawVarint64() throws IOException {
            block4: {
                long l2;
                long l3;
                block6: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n2;
                                    block8: {
                                        block7: {
                                            block5: {
                                                l3 = this.pos;
                                                if (this.limit == l3) break block4;
                                                if ((n2 = UnsafeUtil.getByte(l3++)) >= 0) {
                                                    this.pos = l3;
                                                    return n2;
                                                }
                                                if (this.limit - l3 < 9L) break block4;
                                                if ((n2 ^= UnsafeUtil.getByte(l3++) << 7) >= 0) break block5;
                                                l2 = n2 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n2 ^= UnsafeUtil.getByte(l3++) << 14) < 0) break block7;
                                            l2 = n2 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n2 ^= UnsafeUtil.getByte(l3++) << 21) >= 0) break block8;
                                        l2 = n2 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n2 ^ (long)UnsafeUtil.getByte(l3++) << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)UnsafeUtil.getByte(l3++) << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)UnsafeUtil.getByte(l3++) << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)UnsafeUtil.getByte(l3++) < 0L) break block4;
                }
                this.pos = l3;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final int readRawLittleEndian32() throws IOException {
            long l2 = this.pos;
            if (this.limit - l2 < 4L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l2 + 4L;
            return UnsafeUtil.getByte(l2) & 0xFF | (UnsafeUtil.getByte(l2 + 1L) & 0xFF) << 8 | (UnsafeUtil.getByte(l2 + 2L) & 0xFF) << 16 | (UnsafeUtil.getByte(l2 + 3L) & 0xFF) << 24;
        }

        @Override
        public final long readRawLittleEndian64() throws IOException {
            long l2 = this.pos;
            if (this.limit - l2 < 8L) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.pos = l2 + 8L;
            return (long)UnsafeUtil.getByte(l2) & 0xFFL | ((long)UnsafeUtil.getByte(l2 + 1L) & 0xFFL) << 8 | ((long)UnsafeUtil.getByte(l2 + 2L) & 0xFFL) << 16 | ((long)UnsafeUtil.getByte(l2 + 3L) & 0xFFL) << 24 | ((long)UnsafeUtil.getByte(l2 + 4L) & 0xFFL) << 32 | ((long)UnsafeUtil.getByte(l2 + 5L) & 0xFFL) << 40 | ((long)UnsafeUtil.getByte(l2 + 6L) & 0xFFL) << 48 | ((long)UnsafeUtil.getByte(l2 + 7L) & 0xFFL) << 56;
        }

        @Override
        public final void enableAliasing(boolean enabled) {
            this.enableAliasing = enabled;
        }

        @Override
        public final void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            int n2;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = byteLimit;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        @Override
        public final void popLimit(int oldLimit) {
            this.currentLimit = oldLimit;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return this.pos == this.limit;
        }

        @Override
        public final int getTotalBytesRead() {
            return (int)(this.pos - this.startPos);
        }

        @Override
        public final byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return UnsafeUtil.getByte(this.pos++);
        }

        @Override
        public final byte[] readRawBytes(int length) throws IOException {
            if (length >= 0 && length <= this.remaining()) {
                byte[] byArray = new byte[length];
                UnsafeDirectNioDecoder unsafeDirectNioDecoder = this;
                unsafeDirectNioDecoder.slice(unsafeDirectNioDecoder.pos, this.pos + (long)length).get(byArray);
                this.pos += (long)length;
                return byArray;
            }
            if (length <= 0) {
                if (length == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void skipRawBytes(int length) throws IOException {
            if (length >= 0 && length <= this.remaining()) {
                this.pos += (long)length;
                return;
            }
            if (length < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += (long)this.bufferSizeAfterLimit;
            int n2 = (int)(this.limit - this.startPos);
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.limit -= (long)this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        private int remaining() {
            return (int)(this.limit - this.pos);
        }

        private int bufferPos(long pos) {
            return (int)(pos - this.address);
        }

        private ByteBuffer slice(long begin, long end) throws IOException {
            int n2 = this.buffer.position();
            int n3 = this.buffer.limit();
            try {
                this.buffer.position(this.bufferPos(begin));
                this.buffer.limit(this.bufferPos(end));
                ByteBuffer byteBuffer = this.buffer.slice();
                return byteBuffer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            finally {
                this.buffer.position(n2);
                this.buffer.limit(n3);
            }
        }
    }

    private static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private boolean enableAliasing;
        private int currentLimit = Integer.MAX_VALUE;

        private ArrayDecoder(byte[] buffer, int offset, int len, boolean immutable) {
            this.buffer = buffer;
            this.limit = offset + len;
            this.startPos = this.pos = offset;
            this.immutable = immutable;
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            if (this.lastTag != value) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        @Override
        public final int getLastTag() {
            return this.lastTag;
        }

        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.skipRawVarint();
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    ArrayDecoder arrayDecoder = this;
                    arrayDecoder.skipRawBytes(arrayDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    this.skipMessage();
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final boolean skipField(int tag, CodedOutputStream output) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    long l2 = this.readInt64();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(l2);
                    return true;
                }
                case 1: {
                    long l3 = this.readRawLittleEndian64();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(l3);
                    return true;
                }
                case 2: {
                    ByteString byteString = this.readBytes();
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(byteString);
                    return true;
                }
                case 3: {
                    output.writeRawVarint32(tag);
                    this.skipMessage(output);
                    int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                    this.checkLastTagWas(n2);
                    output.writeRawVarint32(n2);
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    int n3 = this.readRawLittleEndian32();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(n3);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final void skipMessage() throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
            }
        }

        @Override
        public final void skipMessage(CodedOutputStream output) throws IOException {
            int n2;
            while ((n2 = this.readTag()) != 0 && this.skipField(n2, output)) {
            }
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        @Override
        public final String readString() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                String string = Utf8.decodeUtf8(this.buffer, this.pos, n2);
                this.pos += n2;
                return string;
            }
            if (n2 == 0) {
                return "";
            }
            if (n2 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
        }

        @Override
        public final <T extends MessageLite> T readGroup(int fieldNumber, Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
            --this.recursionDepth;
            return (T)messageLite;
        }

        @Override
        @Deprecated
        public final void readUnknownGroup(int fieldNumber, MessageLite.Builder builder) throws IOException {
            this.readGroup(fieldNumber, builder, ExtensionRegistryLite.getEmptyRegistry());
        }

        @Override
        public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            builder.mergeFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
        }

        @Override
        public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.readRawVarint32();
            if (this.recursionDepth >= this.recursionLimit) {
                throw InvalidProtocolBufferException.recursionLimitExceeded();
            }
            int n3 = this.pushLimit(n2);
            ++this.recursionDepth;
            MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistry);
            this.checkLastTagWas(0);
            --this.recursionDepth;
            this.popLimit(n3);
            return (T)messageLite;
        }

        @Override
        public final ByteString readBytes() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                ByteString byteString = this.immutable && this.enableAliasing ? ByteString.wrap(this.buffer, this.pos, n2) : ByteString.copyFrom(this.buffer, this.pos, n2);
                this.pos += n2;
                return byteString;
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            return ByteString.wrap(this.readRawBytes(n2));
        }

        @Override
        public final byte[] readByteArray() throws IOException {
            int n2 = this.readRawVarint32();
            return this.readRawBytes(n2);
        }

        @Override
        public final ByteBuffer readByteBuffer() throws IOException {
            int n2 = this.readRawVarint32();
            if (n2 > 0 && n2 <= this.limit - this.pos) {
                ByteBuffer byteBuffer = !this.immutable && this.enableAliasing ? ByteBuffer.wrap(this.buffer, this.pos, n2).slice() : ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n2));
                this.pos += n2;
                return byteBuffer;
            }
            if (n2 == 0) {
                return Internal.EMPTY_BYTE_BUFFER;
            }
            if (n2 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return ArrayDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        @Override
        public final int readRawVarint32() throws IOException {
            block4: {
                int n2;
                int n3;
                block6: {
                    byte[] byArray;
                    block8: {
                        block7: {
                            block5: {
                                n3 = this.pos;
                                if (this.limit == n3) break block4;
                                byArray = this.buffer;
                                if ((n2 = this.buffer[n3++]) >= 0) {
                                    this.pos = n3;
                                    return n2;
                                }
                                if (this.limit - n3 < 9) break block4;
                                if ((n2 ^= byArray[n3++] << 7) >= 0) break block5;
                                n2 ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((n2 ^= byArray[n3++] << 14) < 0) break block7;
                            n2 ^= 0x3F80;
                            break block6;
                        }
                        if ((n2 ^= byArray[n3++] << 21) >= 0) break block8;
                        n2 ^= 0xFFE03F80;
                        break block6;
                    }
                    byte by2 = byArray[n3++];
                    n2 ^= by2 << 28;
                    n2 ^= 0xFE03F80;
                    if (by2 < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0 && byArray[n3++] < 0) break block4;
                }
                this.pos = n3;
                return n2;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        private void skipRawVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                this.skipRawVarintFastPath();
                return;
            }
            this.skipRawVarintSlowPath();
        }

        private void skipRawVarintFastPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.buffer[this.pos++] < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipRawVarintSlowPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readRawByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final long readRawVarint64() throws IOException {
            block4: {
                long l2;
                int n2;
                block6: {
                    byte[] byArray;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    int n3;
                                    block8: {
                                        block7: {
                                            block5: {
                                                n2 = this.pos;
                                                if (this.limit == n2) break block4;
                                                byArray = this.buffer;
                                                if ((n3 = this.buffer[n2++]) >= 0) {
                                                    this.pos = n2;
                                                    return n3;
                                                }
                                                if (this.limit - n2 < 9) break block4;
                                                if ((n3 ^= byArray[n2++] << 7) >= 0) break block5;
                                                l2 = n3 ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((n3 ^= byArray[n2++] << 14) < 0) break block7;
                                            l2 = n3 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((n3 ^= byArray[n2++] << 21) >= 0) break block8;
                                        l2 = n3 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((l2 = (long)n3 ^ (long)byArray[n2++] << 28) < 0L) break block9;
                                    l2 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((l2 ^= (long)byArray[n2++] << 35) >= 0L) break block10;
                                l2 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((l2 ^= (long)byArray[n2++] << 42) < 0L) break block11;
                            l2 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((l2 ^= (long)byArray[n2++] << 49) >= 0L) break block12;
                        l2 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    l2 ^= (long)byArray[n2++] << 56;
                    if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n2++] < 0L) break block4;
                }
                this.pos = n2;
                return l2;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by2 = this.readRawByte();
                l2 |= (long)(by2 & 0x7F) << i2;
                if ((by2 & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        @Override
        public final int readRawLittleEndian32() throws IOException {
            int n2 = this.pos;
            if (this.limit - n2 < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        @Override
        public final long readRawLittleEndian64() throws IOException {
            int n2 = this.pos;
            if (this.limit - n2 < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        @Override
        public final void enableAliasing(boolean enabled) {
            this.enableAliasing = enabled;
        }

        @Override
        public final void resetSizeCounter() {
            this.startPos = this.pos;
        }

        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            int n2;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = byteLimit;
            this.recomputeBufferSizeAfterLimit();
            return n2;
        }

        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int n2 = this.limit - this.startPos;
            if (n2 > this.currentLimit) {
                this.bufferSizeAfterLimit = n2 - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        @Override
        public final void popLimit(int oldLimit) {
            this.currentLimit = oldLimit;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final int getBytesUntilLimit() {
            if (this.currentLimit == Integer.MAX_VALUE) {
                return -1;
            }
            return this.currentLimit - this.getTotalBytesRead();
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return this.pos == this.limit;
        }

        @Override
        public final int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        @Override
        public final byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        @Override
        public final byte[] readRawBytes(int length) throws IOException {
            if (length > 0 && length <= this.limit - this.pos) {
                int n2 = this.pos;
                this.pos += length;
                return Arrays.copyOfRange(this.buffer, n2, this.pos);
            }
            if (length <= 0) {
                if (length == 0) {
                    return Internal.EMPTY_BYTE_ARRAY;
                }
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        @Override
        public final void skipRawBytes(int length) throws IOException {
            if (length >= 0 && length <= this.limit - this.pos) {
                this.pos += length;
                return;
            }
            if (length < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }
}

