/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyField;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.SmallSortedMap;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof FieldSet)) {
            return false;
        }
        FieldSet fieldSet = (FieldSet)o2;
        return this.fields.equals(fieldSet.fields);
    }

    public final int hashCode() {
        return this.fields.hashCode();
    }

    public final FieldSet<FieldDescriptorType> clone() {
        FieldDescriptorLite fieldDescriptorLite;
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldDescriptorLite, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldDescriptorLite, entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public final void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public final Map<FieldDescriptorType, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap smallSortedMap = SmallSortedMap.newFieldMap(16);
            for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
                this.cloneFieldEntry(smallSortedMap, this.fields.getArrayEntryAt(i2));
            }
            for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
                this.cloneFieldEntry(smallSortedMap, entry);
            }
            if (this.fields.isImmutable()) {
                smallSortedMap.makeImmutable();
            }
            return smallSortedMap;
        }
        if (this.fields.isImmutable()) {
            return this.fields;
        }
        return Collections.unmodifiableMap(this.fields);
    }

    private void cloneFieldEntry(Map<FieldDescriptorType, Object> map, Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            map.put(fieldDescriptorLite, ((LazyField)object).getValue());
            return;
        }
        map.put(fieldDescriptorLite, object);
    }

    public final Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public final boolean hasField(FieldDescriptorType descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public final Object getField(FieldDescriptorType descriptor) {
        Object object = this.fields.get(descriptor);
        if (object instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public final void setField(FieldDescriptorType descriptor, Object value) {
        if (descriptor.isRepeated()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(value);
            for (Object e2 : arrayList) {
                FieldSet.verifyType(descriptor.getLiteType(), e2);
            }
            value = arrayList;
        } else {
            FieldSet.verifyType(descriptor.getLiteType(), value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value);
    }

    public final void clearField(FieldDescriptorType descriptor) {
        this.fields.remove(descriptor);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public final int getRepeatedFieldCount(FieldDescriptorType descriptor) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public final Object getRepeatedField(FieldDescriptorType descriptor, int index) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(index);
    }

    public final void setRepeatedField(FieldDescriptorType descriptor, int index, Object value) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(descriptor.getLiteType(), value);
        ((List)object).set(index, value);
    }

    public final void addRepeatedField(FieldDescriptorType descriptor, Object value) {
        ArrayList<Object> arrayList;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(descriptor.getLiteType(), value);
        Object object = this.getField(descriptor);
        if (object == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(descriptor, (Object)arrayList);
        } else {
            arrayList = (ArrayList<Object>)object;
        }
        arrayList.add(value);
    }

    private static void verifyType(WireFormat.FieldType type, Object value) {
        Internal.checkNotNull(value);
        boolean bl = false;
        switch (type.getJavaType()) {
            case INT: {
                boolean bl2 = value instanceof Integer;
                break;
            }
            case LONG: {
                boolean bl2 = value instanceof Long;
                break;
            }
            case FLOAT: {
                boolean bl2 = value instanceof Float;
                break;
            }
            case DOUBLE: {
                boolean bl2 = value instanceof Double;
                break;
            }
            case BOOLEAN: {
                boolean bl2 = value instanceof Boolean;
                break;
            }
            case STRING: {
                boolean bl2 = value instanceof String;
                break;
            }
            case BYTE_STRING: {
                bl = value instanceof ByteString || value instanceof byte[];
                break;
            }
            case ENUM: {
                bl = value instanceof Integer || value instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                boolean bl2 = bl = value instanceof MessageLite || value instanceof LazyField;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public final boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            FieldSet fieldSet = this;
            if (fieldSet.isInitialized(fieldSet.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                for (MessageLite messageLite : (List)entry.getValue()) {
                    if (messageLite.isInitialized()) continue;
                    return false;
                }
            } else {
                Object object = entry.getValue();
                if (object instanceof MessageLite) {
                    if (!((MessageLite)object).isInitialized()) {
                        return false;
                    }
                } else {
                    if (object instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type.getWireType();
    }

    public final void mergeFrom(FieldSet<FieldDescriptorType> other) {
        for (int i2 = 0; i2 < other.fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(other.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private Object cloneIfMutable(Object value) {
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            Iterator iterator = ((List)object).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.fields.put((FieldDescriptorType)fieldDescriptorLite, (Object)arrayList);
                    return;
                }
                Object e2 = iterator.next();
                ((List)arrayList).add(this.cloneIfMutable(e2));
            }
        }
        if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
            this.fields.put((FieldDescriptorType)fieldDescriptorLite, this.cloneIfMutable(object));
            return;
        }
        Object object2 = this.getField(fieldDescriptorLite);
        if (object2 == null) {
            this.fields.put((FieldDescriptorType)fieldDescriptorLite, this.cloneIfMutable(object));
            return;
        }
        object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
        this.fields.put((FieldDescriptorType)fieldDescriptorLite, object2);
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.LOOSE);
    }

    public final void writeTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    public final void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            FieldSet fieldSet = this;
            fieldSet.writeMessageSetTo(fieldSet.fields.getArrayEntryAt(i2), output);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output);
        }
    }

    private void writeMessageSetTo(Map.Entry<FieldDescriptorType, Object> entry, CodedOutputStream output) throws IOException {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
            return;
        }
        FieldSet.writeField(fieldDescriptorLite, entry.getValue(), output);
    }

    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value) throws IOException {
        if (type == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
            return;
        }
        output.writeTag(number, FieldSet.getWireFormatForFieldType(type, false));
        FieldSet.writeElementNoTag(output, type, value);
    }

    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value) throws IOException {
        switch (type) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value);
                return;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value).floatValue());
                return;
            }
            case INT64: {
                output.writeInt64NoTag((Long)value);
                return;
            }
            case UINT64: {
                output.writeUInt64NoTag((Long)value);
                return;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value);
                return;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value);
                return;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value);
                return;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value);
                return;
            }
            case GROUP: {
                output.writeGroupNoTag((MessageLite)value);
                return;
            }
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)value);
                return;
            }
            case STRING: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeStringNoTag((String)value);
                return;
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeByteArrayNoTag((byte[])value);
                return;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value);
                return;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value);
                return;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value);
                return;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value);
                return;
            }
            case SINT64: {
                output.writeSInt64NoTag((Long)value);
                return;
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    return;
                }
                output.writeEnumNoTag((Integer)value);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldDescriptorLite<?> descriptor, Object value, CodedOutputStream output) throws IOException {
        WireFormat.FieldType fieldType = descriptor.getLiteType();
        int n2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List list = (List)value;
            if (descriptor.isPacked()) {
                output.writeTag(n2, 2);
                int n3 = 0;
                for (Object e2 : list) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                output.writeRawVarint32(n3);
                for (Object e2 : list) {
                    FieldSet.writeElementNoTag(output, fieldType, e2);
                }
                return;
            } else {
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Object e3 = iterator.next();
                    FieldSet.writeElement(output, fieldType, n2, e3);
                }
            }
        }
        if (value instanceof LazyField) {
            FieldSet.writeElement(output, fieldType, n2, ((LazyField)value).getValue());
            return;
        }
        FieldSet.writeElement(output, fieldType, n2, value);
    }

    public final int getSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n2;
    }

    public final int getMessageSetSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            FieldSet fieldSet = this;
            n2 += fieldSet.getMessageSetSerializedSize(fieldSet.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n2 += this.getMessageSetSerializedSize(entry);
        }
        return n2;
    }

    private int getMessageSetSerializedSize(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            if (object instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)object);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, object);
    }

    static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        int n2 = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            n2 <<= 1;
        }
        return n2 + FieldSet.computeElementSizeNoTag(type, value);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        switch (type) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case STRING: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value) {
        WireFormat.FieldType fieldType = descriptor.getLiteType();
        int n2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            if (descriptor.isPacked()) {
                int n3 = 0;
                for (Object e2 : (List)value) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                return n3 + CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeRawVarint32Size(n3);
            }
            int n4 = 0;
            for (Object e3 : (List)value) {
                n4 += FieldSet.computeElementSize(fieldType, n2, e3);
            }
            return n4;
        }
        return FieldSet.computeElementSize(fieldType, n2, value);
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

