/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.Descriptors;
import ai.h2o.com.google.protobuf.ExtensionRegistry;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.Message;
import ai.h2o.com.google.protobuf.MessageOrBuilder;
import ai.h2o.com.google.protobuf.MessageReflection;
import ai.h2o.com.google.protobuf.TextFormatEscaper;
import ai.h2o.com.google.protobuf.TextFormatParseInfoTree;
import ai.h2o.com.google.protobuf.TextFormatParseLocation;
import ai.h2o.com.google.protobuf.UnknownFieldSet;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message, Appendable output) throws IOException {
        Printer.DEFAULT.print(message, TextFormat.multiLineOutput(output));
    }

    public static void print(UnknownFieldSet fields, Appendable output) throws IOException {
        Printer.DEFAULT.printUnknownFields(fields, TextFormat.multiLineOutput(output));
    }

    public static void printUnicode(MessageOrBuilder message, Appendable output) throws IOException {
        Printer.UNICODE.print(message, TextFormat.multiLineOutput(output));
    }

    public static void printUnicode(UnknownFieldSet fields, Appendable output) throws IOException {
        Printer.UNICODE.printUnknownFields(fields, TextFormat.multiLineOutput(output));
    }

    public static String shortDebugString(MessageOrBuilder message) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.print(message, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(Descriptors.FieldDescriptor field, Object value) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.printField(field, value, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.DEFAULT.printUnknownFields(fields, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(MessageOrBuilder message) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(message, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(UnknownFieldSet fields) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(fields, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.UNICODE.print(message, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Printer.UNICODE.printUnknownFields(fields, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value, Appendable output) throws IOException {
        Printer.DEFAULT.printField(field, value, TextFormat.multiLineOutput(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field, Object value) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.printField(field, value, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printUnicodeFieldValue(Descriptors.FieldDescriptor field, Object value, Appendable output) throws IOException {
        Printer.UNICODE.printFieldValue(field, value, TextFormat.multiLineOutput(output));
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field, Object value, Appendable output) throws IOException {
        Printer.DEFAULT.printFieldValue(field, value, TextFormat.multiLineOutput(output));
    }

    public static void printUnknownFieldValue(int tag, Object value, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag, value, TextFormat.multiLineOutput(output));
    }

    private static void printUnknownFieldValue(int tag, Object value, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value));
                return;
            }
            case 5: {
                generator.print(String.format(null, "0x%08x", (Integer)value));
                return;
            }
            case 1: {
                generator.print(String.format(null, "0x%016x", (Long)value));
                return;
            }
            case 2: {
                try {
                    UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)value);
                    generator.print("{");
                    generator.eol();
                    generator.indent();
                    Printer.DEFAULT.printUnknownFields(unknownFieldSet, generator);
                    generator.outdent();
                    generator.print("}");
                    return;
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    generator.print("\"");
                    generator.print(TextFormat.escapeBytes((ByteString)value));
                    generator.print("\"");
                    return;
                }
            }
            case 3: {
                Printer.DEFAULT.printUnknownFields((UnknownFieldSet)value, generator);
                return;
            }
        }
        throw new IllegalArgumentException("Bad tag: " + tag);
    }

    public static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextGenerator multiLineOutput(Appendable output) {
        return new TextGenerator(output, false);
    }

    private static TextGenerator singleLineOutput(Appendable output) {
        return new TextGenerator(output, true);
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        PARSER.merge(input, builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        PARSER.merge(input, builder);
    }

    public static <T extends Message> T parse(CharSequence input, Class<T> protoClass) throws ParseException {
        Message.Builder builder = ((Message)Internal.getDefaultInstance(protoClass)).newBuilderForType();
        TextFormat.merge(input, builder);
        Message message = builder.build();
        return (T)message;
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    public static <T extends Message> T parse(CharSequence input, ExtensionRegistry extensionRegistry, Class<T> protoClass) throws ParseException {
        Message.Builder builder = ((Message)Internal.getDefaultInstance(protoClass)).newBuilderForType();
        TextFormat.merge(input, extensionRegistry, builder);
        Message message = builder.build();
        return (T)message;
    }

    public static String escapeBytes(ByteString input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static String escapeBytes(byte[] input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString byteString = ByteString.copyFromUtf8(charString.toString());
        byte[] byArray = new byte[byteString.size()];
        int n2 = 0;
        block13: for (int i2 = 0; i2 < byteString.size(); ++i2) {
            byte by2 = byteString.byteAt(i2);
            if (by2 == 92) {
                if (i2 + 1 < byteString.size()) {
                    int n3;
                    if (TextFormat.isOctal(by2 = byteString.byteAt(++i2))) {
                        n3 = TextFormat.digitValue(by2);
                        if (i2 + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i2 + 1))) {
                            n3 = (n3 << 3) + TextFormat.digitValue(byteString.byteAt(++i2));
                        }
                        if (i2 + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i2 + 1))) {
                            n3 = (n3 << 3) + TextFormat.digitValue(byteString.byteAt(++i2));
                        }
                        byArray[n2++] = (byte)n3;
                        continue;
                    }
                    switch (by2) {
                        case 97: {
                            byArray[n2++] = 7;
                            continue block13;
                        }
                        case 98: {
                            byArray[n2++] = 8;
                            continue block13;
                        }
                        case 102: {
                            byArray[n2++] = 12;
                            continue block13;
                        }
                        case 110: {
                            byArray[n2++] = 10;
                            continue block13;
                        }
                        case 114: {
                            byArray[n2++] = 13;
                            continue block13;
                        }
                        case 116: {
                            byArray[n2++] = 9;
                            continue block13;
                        }
                        case 118: {
                            byArray[n2++] = 11;
                            continue block13;
                        }
                        case 92: {
                            byArray[n2++] = 92;
                            continue block13;
                        }
                        case 39: {
                            byArray[n2++] = 39;
                            continue block13;
                        }
                        case 34: {
                            byArray[n2++] = 34;
                            continue block13;
                        }
                        case 120: {
                            if (i2 + 1 >= byteString.size() || !TextFormat.isHex(byteString.byteAt(i2 + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n3 = TextFormat.digitValue(byteString.byteAt(++i2));
                            if (i2 + 1 < byteString.size() && TextFormat.isHex(byteString.byteAt(i2 + 1))) {
                                n3 = (n3 << 4) + TextFormat.digitValue(byteString.byteAt(++i2));
                            }
                            byArray[n2++] = (byte)n3;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)by2 + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n2++] = by2;
        }
        if (byArray.length == n2) {
            return ByteString.wrap(byArray);
        }
        return ByteString.copyFrom(byArray, 0, n2);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(input);
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(byte c2) {
        return 48 <= c2 && c2 <= 55;
    }

    private static boolean isHex(byte c2) {
        return 48 <= c2 && c2 <= 57 || 97 <= c2 && c2 <= 102 || 65 <= c2 && c2 <= 70;
    }

    private static int digitValue(byte c2) {
        if (48 <= c2 && c2 <= 57) {
            return c2 - 48;
        }
        if (97 <= c2 && c2 <= 122) {
            return c2 - 97 + 10;
        }
        return c2 - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        long l2;
        int n2 = 0;
        boolean bl = false;
        if (text.startsWith("-", 0)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++n2;
            bl = true;
        }
        int n3 = 10;
        if (text.startsWith("0x", n2)) {
            n2 += 2;
            n3 = 16;
        } else if (text.startsWith("0", n2)) {
            n3 = 8;
        }
        String string = text.substring(n2);
        if (string.length() < 16) {
            l2 = Long.parseLong(string, n3);
            if (bl) {
                l2 = -l2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (l2 >= 0x100000000L || l2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string, n3);
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigInteger.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigInteger.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigInteger.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigInteger.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            l2 = bigInteger.longValue();
        }
        return l2;
    }

    public static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    public static class Parser {
        private final boolean allowUnknownFields;
        private final boolean allowUnknownEnumValues;
        private final boolean allowUnknownExtensions;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private static final int BUFFER_SIZE = 4096;

        private Parser(boolean allowUnknownFields, boolean allowUnknownEnumValues, boolean allowUnknownExtensions, SingularOverwritePolicy singularOverwritePolicy, TextFormatParseInfoTree.Builder parseInfoTreeBuilder) {
            this.allowUnknownFields = allowUnknownFields;
            this.allowUnknownEnumValues = allowUnknownEnumValues;
            this.allowUnknownExtensions = allowUnknownExtensions;
            this.singularOverwritePolicy = singularOverwritePolicy;
            this.parseInfoTreeBuilder = parseInfoTreeBuilder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable input, Message.Builder builder) throws IOException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(CharSequence input, Message.Builder builder) throws ParseException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            this.merge(Parser.toStringBuilder(input), extensionRegistry, builder);
        }

        private static StringBuilder toStringBuilder(Readable input) throws IOException {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while ((n2 = input.read(charBuffer)) != -1) {
                charBuffer.flip();
                stringBuilder.append(charBuffer, 0, n2);
            }
            return stringBuilder;
        }

        private void checkUnknownFields(List<UnknownField> unknownFields) throws ParseException {
            if (unknownFields.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("Input contains unknown fields and/or extensions:");
            for (UnknownField unknownField : unknownFields) {
                stringBuilder.append('\n').append(unknownField.message);
            }
            if (this.allowUnknownFields) {
                logger.warning(stringBuilder.toString());
                return;
            }
            int n2 = 0;
            if (this.allowUnknownExtensions) {
                boolean bl = true;
                for (UnknownField unknownField : unknownFields) {
                    if (unknownField.type == UnknownField.Type.FIELD) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    logger.warning(stringBuilder.toString());
                    return;
                }
            }
            String[] stringArray = unknownFields.get((int)n2).message.split(":");
            throw new ParseException(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringBuilder.toString());
        }

        public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(input);
            MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(builder);
            ArrayList<UnknownField> arrayList = new ArrayList<UnknownField>();
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, builderAdapter, arrayList);
            }
            this.checkUnknownFields(arrayList);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, List<UnknownField> unknownFields) throws ParseException {
            this.mergeField(tokenizer, extensionRegistry, target, this.parseInfoTreeBuilder, unknownFields);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, TextFormatParseInfoTree.Builder parseTreeBuilder, List<UnknownField> unknownFields) throws ParseException {
            Object object;
            Descriptors.FieldDescriptor fieldDescriptor = null;
            int n2 = tokenizer.getLine();
            int n3 = tokenizer.getColumn();
            Descriptors.Descriptor descriptor = target.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extensionInfo = null;
            if (tokenizer.tryConsume("[")) {
                object = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)object).append('.');
                    ((StringBuilder)object).append(tokenizer.consumeIdentifier());
                }
                extensionInfo = target.findExtensionByName(extensionRegistry, ((StringBuilder)object).toString());
                if (extensionInfo == null) {
                    String string = tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + ".[" + object + "]";
                    unknownFields.add(new UnknownField(string, UnknownField.Type.EXTENSION));
                } else {
                    if (extensionInfo.descriptor.getContainingType() != descriptor) {
                        throw tokenizer.parseExceptionPreviousToken("Extension \"" + object + "\" does not extend message type \"" + descriptor.getFullName() + "\".");
                    }
                    fieldDescriptor = extensionInfo.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String string;
                object = tokenizer.consumeIdentifier();
                fieldDescriptor = descriptor.findFieldByName((String)object);
                if (fieldDescriptor == null && (fieldDescriptor = descriptor.findFieldByName(string = ((String)object).toLowerCase(Locale.US))) != null && fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor != null && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP && !fieldDescriptor.getMessageType().getName().equals(object)) {
                    fieldDescriptor = null;
                }
                if (fieldDescriptor == null) {
                    string = tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + descriptor.getFullName() + "." + (String)object;
                    unknownFields.add(new UnknownField(string, UnknownField.Type.FIELD));
                }
            }
            if (fieldDescriptor == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    this.skipFieldValue(tokenizer);
                    return;
                }
                this.skipFieldMessage(tokenizer);
                return;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
                if (parseTreeBuilder != null) {
                    object = parseTreeBuilder.getBuilderForSubMessageField(fieldDescriptor);
                    this.consumeFieldValues(tokenizer, extensionRegistry, target, fieldDescriptor, extensionInfo, (TextFormatParseInfoTree.Builder)object, unknownFields);
                } else {
                    this.consumeFieldValues(tokenizer, extensionRegistry, target, fieldDescriptor, extensionInfo, parseTreeBuilder, unknownFields);
                }
            } else {
                tokenizer.consume(":");
                this.consumeFieldValues(tokenizer, extensionRegistry, target, fieldDescriptor, extensionInfo, parseTreeBuilder, unknownFields);
            }
            if (parseTreeBuilder != null) {
                parseTreeBuilder.setLocation(fieldDescriptor, TextFormatParseLocation.create(n2, n3));
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void consumeFieldValues(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, TextFormatParseInfoTree.Builder parseTreeBuilder, List<UnknownField> unknownFields) throws ParseException {
            if (field.isRepeated() && tokenizer.tryConsume("[")) {
                if (!tokenizer.tryConsume("]")) {
                    while (true) {
                        this.consumeFieldValue(tokenizer, extensionRegistry, target, field, extension, parseTreeBuilder, unknownFields);
                        if (!tokenizer.tryConsume("]")) {
                            tokenizer.consume(",");
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, target, field, extension, parseTreeBuilder, unknownFields);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, TextFormatParseInfoTree.Builder parseTreeBuilder, List<UnknownField> unknownFields) throws ParseException {
            if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && !field.isRepeated()) {
                if (target.hasField(field)) {
                    throw tokenizer.parseExceptionPreviousToken("Non-repeated field \"" + field.getFullName() + "\" cannot be overwritten.");
                }
                if (field.getContainingOneof() != null && target.hasOneof(field.getContainingOneof())) {
                    Descriptors.OneofDescriptor oneofDescriptor = field.getContainingOneof();
                    throw tokenizer.parseExceptionPreviousToken("Field \"" + field.getFullName() + "\" is specified along with field \"" + target.getOneofFieldDescriptor(oneofDescriptor).getFullName() + "\", another member of oneof \"" + oneofDescriptor.getName() + "\".");
                }
            }
            Object object = null;
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                String string;
                if (tokenizer.tryConsume("<")) {
                    string = ">";
                } else {
                    tokenizer.consume("{");
                    string = "}";
                }
                Message message = extension == null ? null : extension.defaultInstance;
                MessageReflection.MergeTarget mergeTarget = target.newMergeTargetForField(field, message);
                while (!tokenizer.tryConsume(string)) {
                    if (tokenizer.atEnd()) {
                        throw tokenizer.parseException("Expected \"" + string + "\".");
                    }
                    this.mergeField(tokenizer, extensionRegistry, mergeTarget, parseTreeBuilder, unknownFields);
                }
                object = mergeTarget.finish();
            } else {
                switch (field.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        object = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        object = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        object = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        object = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        object = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        object = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        object = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        object = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        object = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        Descriptors.EnumDescriptor enumDescriptor = field.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int n2 = tokenizer.consumeInt32();
                            object = enumDescriptor.findValueByNumber(n2);
                            if (object != null) break;
                            String string = "Enum type \"" + enumDescriptor.getFullName() + "\" has no value with number " + n2 + '.';
                            if (this.allowUnknownEnumValues) {
                                logger.warning(string);
                                return;
                            }
                            throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumDescriptor.getFullName() + "\" has no value with number " + n2 + '.');
                        }
                        String string = tokenizer.consumeIdentifier();
                        object = enumDescriptor.findValueByName(string);
                        if (object != null) break;
                        String string2 = "Enum type \"" + enumDescriptor.getFullName() + "\" has no value named \"" + string + "\".";
                        if (this.allowUnknownEnumValues) {
                            logger.warning(string2);
                            return;
                        }
                        throw tokenizer.parseExceptionPreviousToken(string2);
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (field.isRepeated()) {
                target.addRepeatedField(field, object);
                return;
            }
            target.setField(field, object);
        }

        private void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                this.skipFieldValue(tokenizer);
            } else {
                this.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String string;
            if (tokenizer.tryConsume("<")) {
                string = ">";
            } else {
                tokenizer.consume("{");
                string = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                this.skipField(tokenizer);
            }
            tokenizer.consume(string);
        }

        private void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                throw tokenizer.parseException("Invalid field value: " + tokenizer.currentToken);
            }
        }

        static final class UnknownField {
            final String message;
            final Type type;

            UnknownField(String message, Type type) {
                this.message = message;
                this.type = type;
            }

            static enum Type {
                FIELD,
                EXTENSION;

            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private boolean allowUnknownEnumValues = false;
            private boolean allowUnknownExtensions = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;

            public Builder setAllowUnknownExtensions(boolean allowUnknownExtensions) {
                this.allowUnknownExtensions = allowUnknownExtensions;
                return this;
            }

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy p2) {
                this.singularOverwritePolicy = p2;
                return this;
            }

            public Builder setParseInfoTreeBuilder(TextFormatParseInfoTree.Builder parseInfoTreeBuilder) {
                this.parseInfoTreeBuilder = parseInfoTreeBuilder;
                return this;
            }

            public Parser build() {
                return new Parser(this.allowUnknownFields, this.allowUnknownEnumValues, this.allowUnknownExtensions, this.singularOverwritePolicy, this.parseInfoTreeBuilder);
            }
        }

        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class UnknownFieldParseException
    extends ParseException {
        private final String unknownField;

        public UnknownFieldParseException(String message) {
            this(-1, -1, "", message);
        }

        public UnknownFieldParseException(int line, int column, String unknownField, String message) {
            super(line, column, message);
            this.unknownField = unknownField;
        }

        public String getUnknownField() {
            return this.unknownField;
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message) {
            this(-1, -1, message);
        }

        public ParseException(int line, int column, String message) {
            super(Integer.toString(line) + ":" + column + ": " + message);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        final int getPreviousLine() {
            return this.previousLine;
        }

        final int getPreviousColumn() {
            return this.previousColumn;
        }

        final int getLine() {
            return this.line;
        }

        final int getColumn() {
            return this.column;
        }

        public final boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public final void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
                return;
            }
            this.matcher.usePattern(TOKEN);
            if (this.matcher.lookingAt()) {
                this.currentToken = this.matcher.group();
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            } else {
                this.currentToken = String.valueOf(this.text.charAt(this.pos));
                this.matcher.region(this.pos + 1, this.matcher.regionEnd());
            }
            this.skipWhitespace();
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public final boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public final void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public final boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c2 = this.currentToken.charAt(0);
            return '0' <= c2 && c2 <= '9' || c2 == '-' || c2 == '+';
        }

        public final boolean lookingAt(String text) {
            return this.currentToken.equals(text);
        }

        public final String consumeIdentifier() throws ParseException {
            for (int i2 = 0; i2 < this.currentToken.length(); ++i2) {
                char c2 = this.currentToken.charAt(i2);
                if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.') continue;
                throw this.parseException("Expected identifier. Found '" + this.currentToken + "'");
            }
            String string = this.currentToken;
            this.nextToken();
            return string;
        }

        public final boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final int consumeInt32() throws ParseException {
            try {
                int n2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public final int consumeUInt32() throws ParseException {
            try {
                int n2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public final long consumeInt64() throws ParseException {
            try {
                long l2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public final boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final long consumeUInt64() throws ParseException {
            try {
                long l2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public final boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                if (bl) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double d2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public final boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                if (bl) {
                    return Float.NEGATIVE_INFINITY;
                }
                return Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float f2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public final boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("True") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("False") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\". Found \"" + this.currentToken + "\".");
        }

        public final String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public final boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public final ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            this.consumeByteString(arrayList);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(arrayList);
            }
            return ByteString.copyFrom(arrayList);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char c2 = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (c2 != '\"' && c2 != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c2) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String string = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString byteString = TextFormat.unescapeBytes(string);
                this.nextToken();
                list.add(byteString);
                return;
            }
            catch (InvalidEscapeSequenceException invalidEscapeSequenceException) {
                throw this.parseException(invalidEscapeSequenceException.getMessage());
            }
        }

        public final ParseException parseException(String description) {
            return new ParseException(this.line + 1, this.column + 1, description);
        }

        public final ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description);
        }

        private ParseException integerParseException(NumberFormatException e2) {
            return this.parseException("Couldn't parse integer: " + e2.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e2) {
            return this.parseException("Couldn't parse number: " + e2.getMessage());
        }

        public final UnknownFieldParseException unknownFieldParseExceptionPreviousToken(String unknownField, String description) {
            return new UnknownFieldParseException(this.previousLine + 1, this.previousColumn + 1, unknownField, description);
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        private TextGenerator(Appendable output, boolean singleLineMode) {
            this.output = output;
            this.singleLineMode = singleLineMode;
        }

        public final void indent() {
            this.indent.append("  ");
        }

        public final void outdent() {
            int n2 = this.indent.length();
            if (n2 == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength(n2 - 2);
        }

        public final void print(CharSequence text) throws IOException {
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append(text);
        }

        public final void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }
    }

    private static final class Printer {
        static final Printer DEFAULT = new Printer(true);
        static final Printer UNICODE = new Printer(false);
        private final boolean escapeNonAscii;

        private Printer(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
        }

        private void print(MessageOrBuilder message, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
                this.printField(entry.getKey(), entry.getValue(), generator);
            }
            this.printUnknownFields(message.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            if (field.isRepeated()) {
                for (Object e2 : (List)value) {
                    this.printSingleField(field, e2, generator);
                }
                return;
            }
            this.printSingleField(field, value, generator);
        }

        private void printSingleField(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            if (field.isExtension()) {
                generator.print("[");
                if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                    generator.print(field.getMessageType().getFullName());
                } else {
                    generator.print(field.getFullName());
                }
                generator.print("]");
            } else if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print(" {");
                generator.eol();
                generator.indent();
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field, value, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.outdent();
                generator.print("}");
            }
            generator.eol();
        }

        private void printFieldValue(Descriptors.FieldDescriptor field, Object value, TextGenerator generator) throws IOException {
            switch (field.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value).toString());
                    return;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value).toString());
                    return;
                }
                case BOOL: {
                    generator.print(((Boolean)value).toString());
                    return;
                }
                case FLOAT: {
                    generator.print(((Float)value).toString());
                    return;
                }
                case DOUBLE: {
                    generator.print(((Double)value).toString());
                    return;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value));
                    return;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value));
                    return;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)value) : TextFormat.escapeDoubleQuotesAndBackslashes((String)value).replace("\n", "\\n"));
                    generator.print("\"");
                    return;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value instanceof ByteString) {
                        generator.print(TextFormat.escapeBytes((ByteString)value));
                    } else {
                        generator.print(TextFormat.escapeBytes((byte[])value));
                    }
                    generator.print("\"");
                    return;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                    return;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value, generator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int n2 = entry.getKey();
                UnknownFieldSet.Field field = entry.getValue();
                this.printUnknownField(n2, 0, field.getVarintList(), generator);
                this.printUnknownField(n2, 5, field.getFixed32List(), generator);
                this.printUnknownField(n2, 1, field.getFixed64List(), generator);
                this.printUnknownField(n2, 2, field.getLengthDelimitedList(), generator);
                for (UnknownFieldSet unknownFieldSet : field.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    generator.print(" {");
                    generator.eol();
                    generator.indent();
                    this.printUnknownFields(unknownFieldSet, generator);
                    generator.outdent();
                    generator.print("}");
                    generator.eol();
                }
            }
        }

        private void printUnknownField(int number, int wireType, List<?> values, TextGenerator generator) throws IOException {
            for (Object obj : values) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, obj, generator);
                generator.eol();
            }
        }
    }
}

