/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;

final class TextFormatEscaper {
    private TextFormatEscaper() {
    }

    static String escapeBytes(ByteSequence input) {
        StringBuilder stringBuilder = new StringBuilder(input.size());
        block12: for (int i2 = 0; i2 < input.size(); ++i2) {
            byte by2 = input.byteAt(i2);
            switch (by2) {
                case 7: {
                    stringBuilder.append("\\a");
                    continue block12;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    continue block12;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block12;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (by2 >= 32 && by2 <= 126) {
                        stringBuilder.append((char)by2);
                        continue block12;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)(48 + (by2 >>> 6 & 3)));
                    stringBuilder.append((char)(48 + (by2 >>> 3 & 7)));
                    stringBuilder.append((char)(48 + (by2 & 7)));
                }
            }
        }
        return stringBuilder.toString();
    }

    static String escapeBytes(final ByteString input) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public final int size() {
                return input.size();
            }

            @Override
            public final byte byteAt(int offset) {
                return input.byteAt(offset);
            }
        });
    }

    static String escapeBytes(final byte[] input) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public final int size() {
                return input.length;
            }

            @Override
            public final byte byteAt(int offset) {
                return input[offset];
            }
        });
    }

    static String escapeText(String input) {
        return TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(input));
    }

    static String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static interface ByteSequence {
        public int size();

        public byte byteAt(int var1);
    }
}

