/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.Android;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.UnsafeUtil;
import java.nio.ByteBuffer;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    public static boolean isValidUtf8(byte[] bytes) {
        return processor.isValidUtf8(bytes, 0, bytes.length);
    }

    public static boolean isValidUtf8(byte[] bytes, int index, int limit) {
        return processor.isValidUtf8(bytes, index, limit);
    }

    public static int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
        return processor.partialIsValidUtf8(state, bytes, index, limit);
    }

    private static int incompleteStateFor(int byte1) {
        if (byte1 > -12) {
            return -1;
        }
        return byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        if (byte1 > -12 || byte2 > -65) {
            return -1;
        }
        return byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        if (byte1 > -12 || byte2 > -65 || byte3 > -65) {
            return -1;
        }
        return byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes, int index, int limit) {
        byte by2 = bytes[index - 1];
        switch (limit - index) {
            case 0: {
                return Utf8.incompleteStateFor(by2);
            }
            case 1: {
                return Utf8.incompleteStateFor(by2, bytes[index]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by2, (int)bytes[index], (int)bytes[index + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer buffer, int byte1, int index, int remaining) {
        switch (remaining) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, buffer.get(index));
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)buffer.get(index), (int)buffer.get(index + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence sequence) {
        int n2;
        int n3;
        int n4 = n3 = sequence.length();
        for (n2 = 0; n2 < n3 && sequence.charAt(n2) < '\u0080'; ++n2) {
        }
        while (n2 < n3) {
            char c2 = sequence.charAt(n2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
            } else {
                n4 += Utf8.encodedLengthGeneral(sequence, n2);
                break;
            }
            ++n2;
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n4 + 0x100000000L));
        }
        return n4;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int n2 = sequence.length();
        int n3 = 0;
        for (int i2 = start; i2 < n2; ++i2) {
            char c2 = sequence.charAt(i2);
            if (c2 < '\u0800') {
                n3 += 127 - c2 >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c2 || c2 > '\udfff') continue;
            int n4 = Character.codePointAt(sequence, i2);
            if (n4 < 65536) {
                throw new UnpairedSurrogateException(i2, n2);
            }
            ++i2;
        }
        return n3;
    }

    static int encode(CharSequence in, byte[] out, int offset, int length) {
        return processor.encodeUtf8(in, out, offset, length);
    }

    static boolean isValidUtf8(ByteBuffer buffer) {
        ByteBuffer byteBuffer = buffer;
        return processor.isValidUtf8(byteBuffer, byteBuffer.position(), buffer.remaining());
    }

    static int partialIsValidUtf8(int state, ByteBuffer buffer, int index, int limit) {
        return processor.partialIsValidUtf8(state, buffer, index, limit);
    }

    static String decodeUtf8(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(buffer, index, size);
    }

    static String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(bytes, index, size);
    }

    static void encodeUtf8(CharSequence in, ByteBuffer out) {
        processor.encodeUtf8(in, out);
    }

    private static int estimateConsecutiveAscii(ByteBuffer buffer, int index, int limit) {
        int n2;
        int n3 = limit - 7;
        for (n2 = index; n2 < n3 && (buffer.getLong(n2) & 0x8080808080808080L) == 0L; n2 += 8) {
        }
        return n2 - index;
    }

    private Utf8() {
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b2) {
            return b2 >= 0;
        }

        private static boolean isTwoBytes(byte b2) {
            return b2 < -32;
        }

        private static boolean isThreeBytes(byte b2) {
            return b2 < -16;
        }

        private static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        private static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int n2 = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(n2);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(n2);
        }

        private static boolean isNotTrailingByte(byte b2) {
            return b2 > -65;
        }

        private static int trailingByteValue(byte b2) {
            return b2 & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            if ((index | limit | bytes.length - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", bytes.length, index, limit));
            }
            long l2 = index;
            long l3 = limit;
            if (state != 0) {
                if (l2 >= l3) {
                    return state;
                }
                byte by2 = (byte)state;
                if (by2 < -32) {
                    if (by2 < -62 || UnsafeUtil.getByte(bytes, l2++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(state >> 8));
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(bytes, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || UnsafeUtil.getByte(bytes, l2++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(state >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(bytes, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(state >> 16);
                    }
                    if (by5 == 0) {
                        by5 = UnsafeUtil.getByte(bytes, l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || UnsafeUtil.getByte(bytes, l2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(bytes, l2, (int)(l3 - l2));
        }

        @Override
        final int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index, int limit) {
            if ((index | limit | buffer.limit() - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, limit));
            }
            long l2 = UnsafeUtil.addressOffset(buffer) + (long)index;
            long l3 = l2 + (long)(limit - index);
            if (state != 0) {
                if (l2 >= l3) {
                    return state;
                }
                byte by2 = (byte)state;
                if (by2 < -32) {
                    if (by2 < -62 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(state >> 8));
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(state >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(state >> 16);
                    }
                    if (by5 == 0) {
                        by5 = UnsafeUtil.getByte(l2++);
                        if (l2 >= l3) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || UnsafeUtil.getByte(l2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(l2, (int)(l3 - l2));
        }

        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            byte by2;
            int n2;
            if ((index | size | bytes.length - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
            }
            int n3 = index + size;
            char[] cArray = new char[size];
            int n4 = 0;
            for (n2 = index; n2 < n3 && DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(bytes, (long)n2)); ++n2) {
                DecodeUtil.handleOneByte(by2, cArray, n4++);
            }
            while (n2 < n3) {
                if (DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(bytes, (long)n2++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n4++);
                    while (n2 < n3 && DecodeUtil.isOneByte(by3 = UnsafeUtil.getByte(bytes, (long)n2))) {
                        ++n2;
                        DecodeUtil.handleOneByte(by3, cArray, n4++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n2 >= n3) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, UnsafeUtil.getByte(bytes, (long)n2++), cArray, n4++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n2 >= n3 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, UnsafeUtil.getByte(bytes, (long)n2++), UnsafeUtil.getByte(bytes, (long)n2++), cArray, n4++);
                    continue;
                }
                if (n2 >= n3 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, UnsafeUtil.getByte(bytes, (long)n2++), UnsafeUtil.getByte(bytes, (long)n2++), UnsafeUtil.getByte(bytes, (long)n2++), cArray, n4++);
                ++n4;
            }
            return new String(cArray, 0, n4);
        }

        @Override
        final String decodeUtf8Direct(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            byte by2;
            long l2;
            if ((index | size | buffer.limit() - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, size));
            }
            long l3 = l2 + (long)size;
            char[] cArray = new char[size];
            int n2 = 0;
            for (l2 = UnsafeUtil.addressOffset(buffer) + (long)index; l2 < l3 && DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(l2)); ++l2) {
                DecodeUtil.handleOneByte(by2, cArray, n2++);
            }
            while (l2 < l3) {
                if (DecodeUtil.isOneByte(by2 = UnsafeUtil.getByte(l2++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n2++);
                    while (l2 < l3 && DecodeUtil.isOneByte(by3 = UnsafeUtil.getByte(l2))) {
                        ++l2;
                        DecodeUtil.handleOneByte(by3, cArray, n2++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (l2 >= l3) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, UnsafeUtil.getByte(l2++), cArray, n2++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (l2 >= l3 - 1L) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), cArray, n2++);
                    continue;
                }
                if (l2 >= l3 - 2L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), UnsafeUtil.getByte(l2++), cArray, n2++);
                ++n2;
            }
            return new String(cArray, 0, n2);
        }

        @Override
        final int encodeUtf8(CharSequence in, byte[] out, int offset, int length) {
            char c2;
            int n2;
            long l2 = offset;
            long l3 = l2 + (long)length;
            int n3 = in.length();
            if (n3 > length || out.length - length < offset) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(n3 - 1) + " at index " + (offset + length));
            }
            for (n2 = 0; n2 < n3 && (c2 = in.charAt(n2)) < '\u0080'; ++n2) {
                UnsafeUtil.putByte(out, l2++, (byte)c2);
            }
            if (n2 == n3) {
                return (int)l2;
            }
            while (n2 < n3) {
                c2 = in.charAt(n2);
                if (c2 < '\u0080' && l2 < l3) {
                    UnsafeUtil.putByte(out, l2++, (byte)c2);
                } else if (c2 < '\u0800' && l2 <= l3 - 2L) {
                    UnsafeUtil.putByte(out, l2++, (byte)(0x3C0 | c2 >>> 6));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & c2));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && l2 <= l3 - 3L) {
                    UnsafeUtil.putByte(out, l2++, (byte)(0x1E0 | c2 >>> 12));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & c2));
                } else if (l2 <= l3 - 4L) {
                    char c3;
                    if (n2 + 1 == n3 || !Character.isSurrogatePair(c2, c3 = in.charAt(++n2))) {
                        throw new UnpairedSurrogateException(n2 - 1, n3);
                    }
                    int n4 = Character.toCodePoint(c2, c3);
                    UnsafeUtil.putByte(out, l2++, (byte)(0xF0 | n4 >>> 18));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    UnsafeUtil.putByte(out, l2++, (byte)(0x80 | 0x3F & n4));
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n2 + 1 != n3 && Character.isSurrogatePair(c2, in.charAt(n2 + 1)))) {
                        throw new UnpairedSurrogateException(n2, n3);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + l2);
                }
                ++n2;
            }
            return (int)l2;
        }

        @Override
        final void encodeUtf8Direct(CharSequence in, ByteBuffer out) {
            char c2;
            int n2;
            long l2 = UnsafeUtil.addressOffset(out);
            long l3 = l2 + (long)out.position();
            long l4 = l2 + (long)out.limit();
            int n3 = in.length();
            if ((long)n3 > l4 - l3) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(n3 - 1) + " at index " + out.limit());
            }
            for (n2 = 0; n2 < n3 && (c2 = in.charAt(n2)) < '\u0080'; ++n2) {
                UnsafeUtil.putByte(l3++, (byte)c2);
            }
            if (n2 == n3) {
                out.position((int)(l3 - l2));
                return;
            }
            while (n2 < n3) {
                c2 = in.charAt(n2);
                if (c2 < '\u0080' && l3 < l4) {
                    UnsafeUtil.putByte(l3++, (byte)c2);
                } else if (c2 < '\u0800' && l3 <= l4 - 2L) {
                    UnsafeUtil.putByte(l3++, (byte)(0x3C0 | c2 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2));
                } else if ((c2 < '\ud800' || '\udfff' < c2) && l3 <= l4 - 3L) {
                    UnsafeUtil.putByte(l3++, (byte)(0x1E0 | c2 >>> 12));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & c2));
                } else if (l3 <= l4 - 4L) {
                    char c3;
                    if (n2 + 1 == n3 || !Character.isSurrogatePair(c2, c3 = in.charAt(++n2))) {
                        throw new UnpairedSurrogateException(n2 - 1, n3);
                    }
                    int n4 = Character.toCodePoint(c2, c3);
                    UnsafeUtil.putByte(l3++, (byte)(0xF0 | n4 >>> 18));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    UnsafeUtil.putByte(l3++, (byte)(0x80 | 0x3F & n4));
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n2 + 1 != n3 && Character.isSurrogatePair(c2, in.charAt(n2 + 1)))) {
                        throw new UnpairedSurrogateException(n2, n3);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + l3);
                }
                ++n2;
            }
            out.position((int)(l3 - l2));
        }

        private static int unsafeEstimateConsecutiveAscii(byte[] bytes, long offset, int maxChars) {
            if (maxChars < 16) {
                return 0;
            }
            for (int i2 = 0; i2 < maxChars; ++i2) {
                if (UnsafeUtil.getByte(bytes, offset++) >= 0) continue;
                return i2;
            }
            return maxChars;
        }

        private static int unsafeEstimateConsecutiveAscii(long address, int maxChars) {
            int remaining;
            int n2;
            if (maxChars < 16) {
                return 0;
            }
            for (int i2 = n2 = 8 - ((int)address & 7); i2 > 0; --i2) {
                if (UnsafeUtil.getByte(address++) >= 0) continue;
                return n2 - i2;
            }
            for (remaining = maxChars - n2; remaining >= 8 && (UnsafeUtil.getLong(address) & 0x8080808080808080L) == 0L; remaining -= 8) {
                address += 8L;
            }
            return maxChars - remaining;
        }

        private static int partialIsValidUtf8(byte[] bytes, long offset, int remaining) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(bytes, offset, remaining);
            remaining -= n2;
            offset += (long)n2;
            while (true) {
                byte by2;
                int n3 = 0;
                while (remaining > 0) {
                    byte by3 = UnsafeUtil.getByte(bytes, offset++);
                    n3 = by3;
                    if (by3 < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (n3 < -32) {
                    if (remaining == 0) {
                        return n3;
                    }
                    --remaining;
                    if (n3 >= -62 && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (n3 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(bytes, n3, offset, remaining);
                    }
                    remaining -= 2;
                    if (!((by2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || n3 == -32 && by2 < -96 || n3 == -19 && by2 >= -96) && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(bytes, n3, offset, remaining);
                }
                remaining -= 3;
                if ((by2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || (n3 << 28) + (by2 - -112) >> 30 != 0 || UnsafeUtil.getByte(bytes, offset++) > -65 || UnsafeUtil.getByte(bytes, offset++) > -65) break;
            }
            return -1;
        }

        private static int partialIsValidUtf8(long address, int remaining) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(address, remaining);
            address += (long)n2;
            remaining -= n2;
            while (true) {
                byte by2;
                int n3 = 0;
                while (remaining > 0) {
                    byte by3 = UnsafeUtil.getByte(address++);
                    n3 = by3;
                    if (by3 < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (n3 < -32) {
                    if (remaining == 0) {
                        return n3;
                    }
                    --remaining;
                    if (n3 >= -62 && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (n3 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(address, n3, remaining);
                    }
                    remaining -= 2;
                    if (!((by2 = UnsafeUtil.getByte(address++)) > -65 || n3 == -32 && by2 < -96 || n3 == -19 && by2 >= -96) && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(address, n3, remaining);
                }
                remaining -= 3;
                if ((by2 = UnsafeUtil.getByte(address++)) > -65 || (n3 << 28) + (by2 - -112) >> 30 != 0 || UnsafeUtil.getByte(address++) > -65 || UnsafeUtil.getByte(address++) > -65) break;
            }
            return -1;
        }

        private static int unsafeIncompleteStateFor(byte[] bytes, int byte1, long offset, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes, offset));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes, offset), UnsafeUtil.getByte(bytes, offset + 1L));
                }
            }
            throw new AssertionError();
        }

        private static int unsafeIncompleteStateFor(long address, int byte1, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address), UnsafeUtil.getByte(address + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            if (state != 0) {
                if (index >= limit) {
                    return state;
                }
                byte by2 = (byte)state;
                if (by2 < -32) {
                    if (by2 < -62 || bytes[index++] > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(state >> 8));
                    if (by3 == 0) {
                        by3 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || bytes[index++] > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(state >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(state >> 16);
                    }
                    if (by5 == 0) {
                        by5 = bytes[index++];
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || bytes[index++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8(bytes, index, limit);
        }

        @Override
        final int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index, int limit) {
            return this.partialIsValidUtf8Default(state, buffer, index, limit);
        }

        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            byte by2;
            int n2;
            if ((index | size | bytes.length - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
            }
            int n3 = index + size;
            char[] cArray = new char[size];
            int n4 = 0;
            for (n2 = index; n2 < n3 && DecodeUtil.isOneByte(by2 = bytes[n2]); ++n2) {
                DecodeUtil.handleOneByte(by2, cArray, n4++);
            }
            while (n2 < n3) {
                if (DecodeUtil.isOneByte(by2 = bytes[n2++])) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n4++);
                    while (n2 < n3 && DecodeUtil.isOneByte(by3 = bytes[n2])) {
                        ++n2;
                        DecodeUtil.handleOneByte(by3, cArray, n4++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n2 >= n3) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, bytes[n2++], cArray, n4++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n2 >= n3 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, bytes[n2++], bytes[n2++], cArray, n4++);
                    continue;
                }
                if (n2 >= n3 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, bytes[n2++], bytes[n2++], bytes[n2++], cArray, n4++);
                ++n4;
            }
            return new String(cArray, 0, n4);
        }

        @Override
        final String decodeUtf8Direct(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            return this.decodeUtf8Default(buffer, index, size);
        }

        @Override
        final int encodeUtf8(CharSequence in, byte[] out, int offset, int length) {
            char c2;
            int n2;
            int n3 = in.length();
            int n4 = offset + length;
            for (n2 = 0; n2 < n3 && n2 + offset < n4 && (c2 = in.charAt(n2)) < '\u0080'; ++n2) {
                out[offset + n2] = (byte)c2;
            }
            if (n2 == n3) {
                return offset + n3;
            }
            int n5 = offset + n2;
            while (n2 < n3) {
                c2 = in.charAt(n2);
                if (c2 < '\u0080' && n5 < n4) {
                    out[n5++] = (byte)c2;
                } else if (c2 < '\u0800' && n5 <= n4 - 2) {
                    out[n5++] = (byte)(0x3C0 | c2 >>> 6);
                    out[n5++] = (byte)(0x80 | 0x3F & c2);
                } else if ((c2 < '\ud800' || '\udfff' < c2) && n5 <= n4 - 3) {
                    out[n5++] = (byte)(0x1E0 | c2 >>> 12);
                    out[n5++] = (byte)(0x80 | 0x3F & c2 >>> 6);
                    out[n5++] = (byte)(0x80 | 0x3F & c2);
                } else if (n5 <= n4 - 4) {
                    char c3;
                    if (n2 + 1 == in.length() || !Character.isSurrogatePair(c2, c3 = in.charAt(++n2))) {
                        throw new UnpairedSurrogateException(n2 - 1, n3);
                    }
                    int n6 = Character.toCodePoint(c2, c3);
                    out[n5++] = (byte)(0xF0 | n6 >>> 18);
                    out[n5++] = (byte)(0x80 | 0x3F & n6 >>> 12);
                    out[n5++] = (byte)(0x80 | 0x3F & n6 >>> 6);
                    out[n5++] = (byte)(0x80 | 0x3F & n6);
                } else {
                    if (!('\ud800' > c2 || c2 > '\udfff' || n2 + 1 != in.length() && Character.isSurrogatePair(c2, in.charAt(n2 + 1)))) {
                        throw new UnpairedSurrogateException(n2, n3);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c2 + " at index " + n5);
                }
                ++n2;
            }
            return n5;
        }

        @Override
        final void encodeUtf8Direct(CharSequence in, ByteBuffer out) {
            this.encodeUtf8Default(in, out);
        }

        private static int partialIsValidUtf8(byte[] bytes, int index, int limit) {
            while (index < limit && bytes[index] >= 0) {
                ++index;
            }
            if (index >= limit) {
                return 0;
            }
            return SafeProcessor.partialIsValidUtf8NonAscii(bytes, index, limit);
        }

        private static int partialIsValidUtf8NonAscii(byte[] bytes, int index, int limit) {
            while (true) {
                byte by2;
                byte by3;
                if (index >= limit) {
                    return 0;
                }
                if ((by3 = bytes[index++]) >= 0) continue;
                if (by3 < -32) {
                    if (index >= limit) {
                        return by3;
                    }
                    if (by3 >= -62 && bytes[index++] <= -65) continue;
                    return -1;
                }
                if (by3 < -16) {
                    if (index >= limit - 1) {
                        return Utf8.incompleteStateFor(bytes, index, limit);
                    }
                    if (!((by2 = bytes[index++]) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && by2 >= -96) && bytes[index++] <= -65) continue;
                    return -1;
                }
                if (index >= limit - 2) {
                    return Utf8.incompleteStateFor(bytes, index, limit);
                }
                if ((by2 = bytes[index++]) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || bytes[index++] > -65 || bytes[index++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        final boolean isValidUtf8(byte[] bytes, int index, int limit) {
            return this.partialIsValidUtf8(0, bytes, index, limit) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        final boolean isValidUtf8(ByteBuffer buffer, int index, int limit) {
            return this.partialIsValidUtf8(0, buffer, index, limit) == 0;
        }

        final int partialIsValidUtf8(int state, ByteBuffer buffer, int index, int limit) {
            if (buffer.hasArray()) {
                int n2 = buffer.arrayOffset();
                return this.partialIsValidUtf8(state, buffer.array(), n2 + index, n2 + limit);
            }
            if (buffer.isDirect()) {
                return this.partialIsValidUtf8Direct(state, buffer, index, limit);
            }
            return this.partialIsValidUtf8Default(state, buffer, index, limit);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final int partialIsValidUtf8Default(int state, ByteBuffer buffer, int index, int limit) {
            if (state != 0) {
                if (index >= limit) {
                    return state;
                }
                byte by2 = (byte)state;
                if (by2 < -32) {
                    if (by2 < -62 || buffer.get(index++) > -65) {
                        return -1;
                    }
                } else if (by2 < -16) {
                    byte by3 = (byte)(~(state >> 8));
                    if (by3 == 0) {
                        by3 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by3);
                        }
                    }
                    if (by3 > -65 || by2 == -32 && by3 < -96 || by2 == -19 && by3 >= -96 || buffer.get(index++) > -65) {
                        return -1;
                    }
                } else {
                    byte by4 = (byte)(~(state >> 8));
                    byte by5 = 0;
                    if (by4 == 0) {
                        by4 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by4);
                        }
                    } else {
                        by5 = (byte)(state >> 16);
                    }
                    if (by5 == 0) {
                        by5 = buffer.get(index++);
                        if (index >= limit) {
                            return Utf8.incompleteStateFor(by2, by4, by5);
                        }
                    }
                    if (by4 > -65 || (by2 << 28) + (by4 - -112) >> 30 != 0 || by5 > -65 || buffer.get(index++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(buffer, index, limit);
        }

        private static int partialIsValidUtf8(ByteBuffer buffer, int index, int limit) {
            index += Utf8.estimateConsecutiveAscii(buffer, index, limit);
            while (true) {
                byte by2;
                byte by3;
                if (index >= limit) {
                    return 0;
                }
                if ((by3 = buffer.get(index++)) >= 0) continue;
                if (by3 < -32) {
                    if (index >= limit) {
                        return by3;
                    }
                    if (by3 < -62 || buffer.get(index) > -65) {
                        return -1;
                    }
                    ++index;
                    continue;
                }
                if (by3 < -16) {
                    if (index >= limit - 1) {
                        return Utf8.incompleteStateFor(buffer, by3, index, limit - index);
                    }
                    if ((by2 = buffer.get(index++)) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && by2 >= -96 || buffer.get(index) > -65) {
                        return -1;
                    }
                    ++index;
                    continue;
                }
                if (index >= limit - 2) {
                    return Utf8.incompleteStateFor(buffer, by3, index, limit - index);
                }
                if ((by2 = buffer.get(index++)) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || buffer.get(index++) > -65 || buffer.get(index++) > -65) break;
            }
            return -1;
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            if (buffer.hasArray()) {
                int n2 = buffer.arrayOffset();
                return this.decodeUtf8(buffer.array(), n2 + index, size);
            }
            if (buffer.isDirect()) {
                return this.decodeUtf8Direct(buffer, index, size);
            }
            return this.decodeUtf8Default(buffer, index, size);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8Default(ByteBuffer buffer, int index, int size) throws InvalidProtocolBufferException {
            byte by2;
            int n2;
            if ((index | size | buffer.limit() - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index, size));
            }
            int n3 = index + size;
            char[] cArray = new char[size];
            int n4 = 0;
            for (n2 = index; n2 < n3 && DecodeUtil.isOneByte(by2 = buffer.get(n2)); ++n2) {
                DecodeUtil.handleOneByte(by2, cArray, n4++);
            }
            while (n2 < n3) {
                if (DecodeUtil.isOneByte(by2 = buffer.get(n2++))) {
                    byte by3;
                    DecodeUtil.handleOneByte(by2, cArray, n4++);
                    while (n2 < n3 && DecodeUtil.isOneByte(by3 = buffer.get(n2))) {
                        ++n2;
                        DecodeUtil.handleOneByte(by3, cArray, n4++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(by2)) {
                    if (n2 >= n3) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(by2, buffer.get(n2++), cArray, n4++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(by2)) {
                    if (n2 >= n3 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(by2, buffer.get(n2++), buffer.get(n2++), cArray, n4++);
                    continue;
                }
                if (n2 >= n3 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(by2, buffer.get(n2++), buffer.get(n2++), buffer.get(n2++), cArray, n4++);
                ++n4;
            }
            return new String(cArray, 0, n4);
        }

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        final void encodeUtf8(CharSequence in, ByteBuffer out) {
            if (out.hasArray()) {
                int n2 = out.arrayOffset();
                int n3 = Utf8.encode(in, out.array(), n2 + out.position(), out.remaining());
                out.position(n3 - n2);
                return;
            }
            if (out.isDirect()) {
                this.encodeUtf8Direct(in, out);
                return;
            }
            this.encodeUtf8Default(in, out);
        }

        abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

        final void encodeUtf8Default(CharSequence in, ByteBuffer out) {
            int n2;
            int n3 = in.length();
            int n4 = out.position();
            try {
                char c2;
                for (n2 = 0; n2 < n3 && (c2 = in.charAt(n2)) < '\u0080'; ++n2) {
                    out.put(n4 + n2, (byte)c2);
                }
                if (n2 == n3) {
                    out.position(n4 + n2);
                    return;
                }
                n4 += n2;
                while (n2 < n3) {
                    c2 = in.charAt(n2);
                    if (c2 < '\u0080') {
                        out.put(n4, (byte)c2);
                    } else if (c2 < '\u0800') {
                        out.put(n4++, (byte)(0xC0 | c2 >>> 6));
                        out.put(n4, (byte)(0x80 | 0x3F & c2));
                    } else if (c2 < '\ud800' || '\udfff' < c2) {
                        out.put(n4++, (byte)(0xE0 | c2 >>> 12));
                        out.put(n4++, (byte)(0x80 | 0x3F & c2 >>> 6));
                        out.put(n4, (byte)(0x80 | 0x3F & c2));
                    } else {
                        char c3;
                        if (n2 + 1 == n3 || !Character.isSurrogatePair(c2, c3 = in.charAt(++n2))) {
                            throw new UnpairedSurrogateException(n2, n3);
                        }
                        int n5 = Character.toCodePoint(c2, c3);
                        out.put(n4++, (byte)(0xF0 | n5 >>> 18));
                        out.put(n4++, (byte)(0x80 | 0x3F & n5 >>> 12));
                        out.put(n4++, (byte)(0x80 | 0x3F & n5 >>> 6));
                        out.put(n4, (byte)(0x80 | 0x3F & n5));
                    }
                    ++n2;
                    ++n4;
                }
                out.position(n4);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                int n6 = out.position() + Math.max(n2, n4 - out.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(n2) + " at index " + n6);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + index + " of " + length);
        }
    }
}

