/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.analysis.Subroutine;
import ai.h2o.javassist.bytecode.analysis.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map<Integer, Subroutine> subTable = new HashMap<Integer, Subroutine>();
    Set<Integer> done = new HashSet<Integer>();

    public Subroutine[] scan(MethodInfo method) throws BadBytecode {
        CodeAttribute code = method.getCodeAttribute();
        CodeIterator iter2 = code.iterator();
        this.subroutines = new Subroutine[code.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, iter2, null);
        ExceptionTable exceptions2 = code.getExceptionTable();
        for (int i2 = 0; i2 < exceptions2.size(); ++i2) {
            int handler = exceptions2.handlerPc(i2);
            this.scan(handler, iter2, this.subroutines[exceptions2.startPc(i2)]);
        }
        return this.subroutines;
    }

    private void scan(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        boolean next;
        if (this.done.contains(pos)) {
            return;
        }
        this.done.add(pos);
        int old = iter2.lookAhead();
        iter2.move(pos);
        while (next = this.scanOp(pos = iter2.next(), iter2, sub) && iter2.hasNext()) {
        }
        iter2.move(old);
    }

    private boolean scanOp(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        this.subroutines[pos] = sub;
        int opcode = iter2.byteAt(pos);
        if (opcode == 170) {
            this.scanTableSwitch(pos, iter2, sub);
            return false;
        }
        if (opcode == 171) {
            this.scanLookupSwitch(pos, iter2, sub);
            return false;
        }
        if (Util.isReturn(opcode) || opcode == 169 || opcode == 191) {
            return false;
        }
        if (Util.isJumpInstruction(opcode)) {
            int target = Util.getJumpTarget(pos, iter2);
            if (opcode == 168 || opcode == 201) {
                Subroutine s2 = this.subTable.get(target);
                if (s2 == null) {
                    s2 = new Subroutine(target, pos);
                    this.subTable.put(target, s2);
                    this.scan(target, iter2, s2);
                } else {
                    s2.addCaller(pos);
                }
            } else {
                this.scan(target, iter2, sub);
                if (Util.isGoto(opcode)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter2.s32bitAt(index), iter2, sub);
        int npairs = iter2.s32bitAt(index += 4);
        int end = npairs * 8 + (index += 4);
        index += 4;
        while (index < end) {
            int target = iter2.s32bitAt(index) + pos;
            this.scan(target, iter2, sub);
            index += 8;
        }
    }

    private void scanTableSwitch(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter2.s32bitAt(index), iter2, sub);
        int low = iter2.s32bitAt(index += 4);
        int high = iter2.s32bitAt(index += 4);
        int end = (high - low + 1) * 4 + (index += 4);
        while (index < end) {
            int target = iter2.s32bitAt(index) + pos;
            this.scan(target, iter2, sub);
            index += 4;
        }
    }
}

