/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public class SubtreeReaderBackend
implements ReaderBackend {
    private final ReaderBackend parent;
    private final String prefix;

    private SubtreeReaderBackend(ReaderBackend parent, String subdir) {
        this.parent = parent;
        this.prefix = subdir.endsWith("/") ? subdir : subdir + "/";
    }

    public static SubtreeReaderBackend from(ReaderBackend parent, String subdir) {
        return new SubtreeReaderBackend(parent, subdir);
    }

    @Override
    public ResourceInfo getResourceInfo(String resourceName) throws IOException {
        return this.parent.getResourceInfo(this.prefix + resourceName);
    }

    @Override
    public InputStream getInputStream(String resourceName) throws IOException {
        return this.parent.getInputStream(this.prefix + resourceName);
    }

    @Override
    public boolean exists(String resourceName) {
        return this.parent.exists(this.prefix + resourceName);
    }

    @Override
    public Collection<String> list() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.parent.list()) {
            if (!name.startsWith(this.prefix)) continue;
            result.add(name.substring(this.prefix.length()));
        }
        return result;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return String.format("%s.%s[%s]", this.parent.toString(), this.getClass().getSimpleName(), this.prefix);
    }
}

