/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MojoFrameMeta
implements Serializable {
    private final List<MojoColumnMeta> columns;
    private final Map<String, Integer> columnNameToIndex = new LinkedHashMap<String, Integer>();
    private final Map<MojoColumnMeta, Integer> columnToIndex = new LinkedHashMap<MojoColumnMeta, Integer>();

    @Deprecated
    public MojoFrameMeta(String[] names, MojoColumn.Type[] types2) {
        this(MojoColumnMeta.toColumns(names, types2, MojoColumn.Kind.Output));
    }

    public MojoFrameMeta(List<MojoColumnMeta> columns) {
        this.columns = columns;
        int index = 0;
        for (MojoColumnMeta column : columns) {
            this.columnNameToIndex.put(column.getColumnName(), index);
            this.columnToIndex.put(column, index);
            ++index;
        }
    }

    public MojoFrameMeta(List<MojoColumnMeta> columns, Collection<Integer> indices) {
        this.columns = columns;
        for (int index : indices) {
            this.columnNameToIndex.put(columns.get(index).getColumnName(), index);
        }
    }

    public MojoFrameMeta subFrame(int[] indices) {
        ArrayList<MojoColumnMeta> columns = new ArrayList<MojoColumnMeta>();
        for (int index : indices) {
            columns.add(this.getColumns().get(index));
        }
        return new MojoFrameMeta(columns);
    }

    public static MojoFrameMeta getEmpty() {
        return new MojoFrameMeta(Collections.emptyList());
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnNameToIndex.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException(String.format("Column '%s' was not found in this frame with %d columns.", columnName, this.size()));
        }
        return index;
    }

    @Deprecated
    public Integer indexOf(String columnName) {
        return this.columnNameToIndex.get(columnName);
    }

    public Integer indexOf(MojoColumnMeta column) {
        return this.columnToIndex.get(column);
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getColumnName();
    }

    public MojoColumn.Type getColumnType(int index) {
        return this.columns.get(index).getColumnType();
    }

    public MojoColumn.Type getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public boolean contains(String columnName) {
        return this.columnNameToIndex.containsKey(columnName);
    }

    public int size() {
        return this.columns.size();
    }

    protected Map<String, Integer> getColumnNamesMap() {
        return this.columnNameToIndex;
    }

    @Deprecated
    public String[] getColumnNames() {
        return this.columnNameToIndex.keySet().toArray(new String[0]);
    }

    @Deprecated
    public MojoColumn.Type[] getColumnTypes() {
        MojoColumn.Type[] columnTypes = new MojoColumn.Type[this.columns.size()];
        for (int i2 = 0; i2 < columnTypes.length; ++i2) {
            columnTypes[i2] = this.columns.get(i2).getColumnType();
        }
        return columnTypes;
    }

    public List<MojoColumnMeta> getColumns() {
        return this.columns;
    }

    public String toString() {
        return MojoFrameMeta.niceToString(this.columns);
    }

    static String niceToString(List<MojoColumnMeta> columns) {
        StringBuilder sb = new StringBuilder("MojoFrameMeta{cols:");
        sb.append(columns.size());
        LinkedHashMap<String, Integer> typestat = new LinkedHashMap<String, Integer>();
        for (MojoColumnMeta col : columns) {
            String key;
            Integer value = (Integer)typestat.get(key = col.getColumnType().toString());
            typestat.put(key, value == null ? 1 : value + 1);
        }
        int sep = 59;
        for (Map.Entry entry : typestat.entrySet()) {
            sb.append(String.format("%s%dx%s", Character.valueOf((char)sep), entry.getValue(), entry.getKey()));
            sep = 44;
        }
        sb.append("}");
        return sb.toString();
    }

    public static String debugIndicesToNames(List<MojoColumnMeta> columns, int[] indices) {
        return Arrays.stream(indices).mapToObj(index -> index < columns.size() ? ((MojoColumnMeta)columns.get(index)).getColumnName() : "IndexTooBig(" + index + ")").collect(Collectors.joining(","));
    }

    public String debugIndicesToNames(int[] indices) {
        return MojoFrameMeta.debugIndicesToNames(this.columns, indices);
    }
}

