/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.client.protocol;

import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpRequestInterceptor;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.client.config.RequestConfig;
import ai.h2o.org.apache.http.client.protocol.HttpClientContext;
import ai.h2o.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i2 = 0; i2 < encodings.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i2));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request2, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (!request2.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request2.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

