/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.impl;

import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.HttpEntityEnclosingRequest;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpResponse;
import ai.h2o.org.apache.http.HttpServerConnection;
import ai.h2o.org.apache.http.config.MessageConstraints;
import ai.h2o.org.apache.http.entity.ContentLengthStrategy;
import ai.h2o.org.apache.http.impl.BHttpConnectionBase;
import ai.h2o.org.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import ai.h2o.org.apache.http.impl.io.DefaultHttpRequestParserFactory;
import ai.h2o.org.apache.http.impl.io.DefaultHttpResponseWriterFactory;
import ai.h2o.org.apache.http.io.HttpMessageParser;
import ai.h2o.org.apache.http.io.HttpMessageParserFactory;
import ai.h2o.org.apache.http.io.HttpMessageWriter;
import ai.h2o.org.apache.http.io.HttpMessageWriterFactory;
import ai.h2o.org.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class DefaultBHttpServerConnection
extends BHttpConnectionBase
implements HttpServerConnection {
    private final HttpMessageParser<HttpRequest> requestParser;
    private final HttpMessageWriter<HttpResponse> responseWriter;

    public DefaultBHttpServerConnection(int bufferSize, int fragmentSizeHint, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
        super(bufferSize, fragmentSizeHint, charDecoder, charEncoder, constraints, incomingContentStrategy != null ? incomingContentStrategy : DisallowIdentityContentLengthStrategy.INSTANCE, outgoingContentStrategy);
        this.requestParser = (requestParserFactory != null ? requestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create(this.getSessionInputBuffer(), constraints);
        this.responseWriter = (responseWriterFactory != null ? responseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
    }

    public DefaultBHttpServerConnection(int bufferSize, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints) {
        this(bufferSize, bufferSize, charDecoder, charEncoder, constraints, null, null, null, null);
    }

    public DefaultBHttpServerConnection(int bufferSize) {
        this(bufferSize, bufferSize, null, null, null, null, null, null, null);
    }

    protected void onRequestReceived(HttpRequest request2) {
    }

    protected void onResponseSubmitted(HttpResponse response) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    @Override
    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        this.ensureOpen();
        HttpRequest request2 = this.requestParser.parse();
        this.onRequestReceived(request2);
        this.incrementRequestCount();
        return request2;
    }

    @Override
    public void receiveRequestEntity(HttpEntityEnclosingRequest request2) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        this.ensureOpen();
        HttpEntity entity = this.prepareInput(request2);
        request2.setEntity(entity);
    }

    @Override
    public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        this.responseWriter.write(response);
        this.onResponseSubmitted(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
    }

    @Override
    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outStream = this.prepareOutput(response);
        entity.writeTo(outStream);
        outStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

