/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.impl.client;

import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.HttpHost;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.client.ClientProtocolException;
import ai.h2o.org.apache.http.client.HttpClient;
import ai.h2o.org.apache.http.client.ResponseHandler;
import ai.h2o.org.apache.http.client.methods.CloseableHttpResponse;
import ai.h2o.org.apache.http.client.methods.HttpUriRequest;
import ai.h2o.org.apache.http.client.utils.URIUtils;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.util.Args;
import ai.h2o.org.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpClient
implements HttpClient,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        return this.doExecute(target, request2, context);
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(request2, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request2), request2, context);
    }

    private static HttpHost determineTarget(HttpUriRequest request2) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request2.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request2) throws IOException, ClientProtocolException {
        return this.execute(request2, (HttpContext)null);
    }

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request2) throws IOException, ClientProtocolException {
        return this.doExecute(target, request2, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        HttpHost target = CloseableHttpClient.determineTarget(request2);
        return this.execute(target, request2, responseHandler, context);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(responseHandler, "Response handler");
        CloseableHttpResponse response = this.execute(target, request2, context);
        try {
            T result = responseHandler.handleResponse(response);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume(entity);
            T t2 = result;
            return t2;
        }
        catch (ClientProtocolException t3) {
            HttpEntity entity = response.getEntity();
            try {
                EntityUtils.consume(entity);
            }
            catch (Exception t2) {
                this.log.warn((Object)"Error consuming content after an exception.", (Throwable)t2);
            }
            throw t3;
        }
        finally {
            response.close();
        }
    }
}

