/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.impl.entity;

import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpMessage;
import ai.h2o.org.apache.http.ProtocolException;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.entity.ContentLengthStrategy;
import ai.h2o.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

