/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.impl.execchain;

import ai.h2o.org.apache.http.ConnectionReuseStrategy;
import ai.h2o.org.apache.http.HttpClientConnection;
import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpHost;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpResponse;
import ai.h2o.org.apache.http.ProtocolException;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.client.config.RequestConfig;
import ai.h2o.org.apache.http.client.methods.CloseableHttpResponse;
import ai.h2o.org.apache.http.client.methods.HttpExecutionAware;
import ai.h2o.org.apache.http.client.methods.HttpRequestWrapper;
import ai.h2o.org.apache.http.client.methods.HttpUriRequest;
import ai.h2o.org.apache.http.client.protocol.HttpClientContext;
import ai.h2o.org.apache.http.client.protocol.RequestClientConnControl;
import ai.h2o.org.apache.http.client.utils.URIUtils;
import ai.h2o.org.apache.http.conn.ConnectionKeepAliveStrategy;
import ai.h2o.org.apache.http.conn.ConnectionRequest;
import ai.h2o.org.apache.http.conn.HttpClientConnectionManager;
import ai.h2o.org.apache.http.conn.routing.HttpRoute;
import ai.h2o.org.apache.http.impl.conn.ConnectionShutdownException;
import ai.h2o.org.apache.http.impl.execchain.ClientExecChain;
import ai.h2o.org.apache.http.impl.execchain.ConnectionHolder;
import ai.h2o.org.apache.http.impl.execchain.HttpResponseProxy;
import ai.h2o.org.apache.http.impl.execchain.RequestAbortedException;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.protocol.HttpProcessor;
import ai.h2o.org.apache.http.protocol.HttpRequestExecutor;
import ai.h2o.org.apache.http.protocol.ImmutableHttpProcessor;
import ai.h2o.org.apache.http.protocol.RequestContent;
import ai.h2o.org.apache.http.protocol.RequestTargetHost;
import ai.h2o.org.apache.http.protocol.RequestUserAgent;
import ai.h2o.org.apache.http.util.Args;
import ai.h2o.org.apache.http.util.VersionInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "ai.h2o.org.apache.http.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper request2, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        try {
            URI uri = request2.getURI();
            if (uri != null) {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, normalizeUri ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uri);
                request2.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request2.getRequestLine().getUri(), ex);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request2, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request2, "HTTP request");
        Args.notNull(context, "HTTP context");
        MinimalClientExec.rewriteRequestURI(request2, route, context.getRequestConfig().isNormalizeUri());
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request2.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request2);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request2, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request2, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return new HttpResponseProxy(response, null);
            }
            return new HttpResponseProxy(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

