/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.protocol;

import ai.h2o.org.apache.http.HttpClientConnection;
import ai.h2o.org.apache.http.HttpEntityEnclosingRequest;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpResponse;
import ai.h2o.org.apache.http.HttpVersion;
import ai.h2o.org.apache.http.ProtocolException;
import ai.h2o.org.apache.http.ProtocolVersion;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.protocol.HttpProcessor;
import ai.h2o.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpRequestExecutor {
    public static final int DEFAULT_WAIT_FOR_CONTINUE = 3000;
    private final int waitForContinue;

    public HttpRequestExecutor(int waitForContinue) {
        this.waitForContinue = Args.positive(waitForContinue, "Wait for continue time");
    }

    public HttpRequestExecutor() {
        this(3000);
    }

    protected boolean canResponseHaveBody(HttpRequest request2, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(request2.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    public HttpResponse execute(HttpRequest request2, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        try {
            HttpResponse response = this.doSendRequest(request2, conn, context);
            if (response == null) {
                response = this.doReceiveResponse(request2, conn, context);
            }
            return response;
        }
        catch (IOException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (HttpException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
        catch (RuntimeException ex) {
            HttpRequestExecutor.closeConnection(conn);
            throw ex;
        }
    }

    private static void closeConnection(HttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preProcess(HttpRequest request2, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        context.setAttribute("http.request", request2);
        processor.process(request2, context);
    }

    protected HttpResponse doSendRequest(HttpRequest request2, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        HttpResponse response = null;
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request_sent", Boolean.FALSE);
        conn.sendRequestHeader(request2);
        if (request2 instanceof HttpEntityEnclosingRequest) {
            boolean sendentity = true;
            ProtocolVersion ver = request2.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)request2).expectContinue() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                conn.flush();
                if (conn.isResponseAvailable(this.waitForContinue)) {
                    int status;
                    response = conn.receiveResponseHeader();
                    if (this.canResponseHaveBody(request2, response)) {
                        conn.receiveResponseEntity(response);
                    }
                    if ((status = response.getStatusLine().getStatusCode()) < 200) {
                        if (status != 100) {
                            throw new ProtocolException("Unexpected response: " + response.getStatusLine());
                        }
                        response = null;
                    } else {
                        sendentity = false;
                    }
                }
            }
            if (sendentity) {
                conn.sendRequestEntity((HttpEntityEnclosingRequest)request2);
            }
        }
        conn.flush();
        context.setAttribute("http.request_sent", Boolean.TRUE);
        return response;
    }

    protected HttpResponse doReceiveResponse(HttpRequest request2, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        HttpResponse response = null;
        int statusCode = 0;
        while (response == null || statusCode < 200) {
            response = conn.receiveResponseHeader();
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 100) {
                throw new ProtocolException("Invalid response: " + response.getStatusLine());
            }
            if (!this.canResponseHaveBody(request2, response)) continue;
            conn.receiveResponseEntity(response);
        }
        return response;
    }

    public void postProcess(HttpResponse response, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        context.setAttribute("http.response", response);
        processor.process(response, context);
    }
}

