/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.protocol;

import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.HttpEntityEnclosingRequest;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpRequestInterceptor;
import ai.h2o.org.apache.http.HttpVersion;
import ai.h2o.org.apache.http.ProtocolException;
import ai.h2o.org.apache.http.ProtocolVersion;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpRequest request2, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        if (request2 instanceof HttpEntityEnclosingRequest) {
            if (this.overwrite) {
                request2.removeHeaders("Transfer-Encoding");
                request2.removeHeaders("Content-Length");
            } else {
                if (request2.containsHeader("Transfer-Encoding")) {
                    throw new ProtocolException("Transfer-encoding header already present");
                }
                if (request2.containsHeader("Content-Length")) {
                    throw new ProtocolException("Content-Length header already present");
                }
            }
            ProtocolVersion ver = request2.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request2).getEntity();
            if (entity == null) {
                request2.addHeader("Content-Length", "0");
                return;
            }
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + ver);
                }
                request2.addHeader("Transfer-Encoding", "chunked");
            } else {
                request2.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !request2.containsHeader("Content-Type")) {
                request2.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !request2.containsHeader("Content-Encoding")) {
                request2.addHeader(entity.getContentEncoding());
            }
        }
    }
}

