/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.client.HttpContentResponse;
import ai.h2o.org.eclipse.jetty.client.HttpConversation;
import ai.h2o.org.eclipse.jetty.client.HttpRequest;
import ai.h2o.org.eclipse.jetty.client.HttpResponseException;
import ai.h2o.org.eclipse.jetty.client.ProtocolHandler;
import ai.h2o.org.eclipse.jetty.client.ResponseNotifier;
import ai.h2o.org.eclipse.jetty.client.api.Authentication;
import ai.h2o.org.eclipse.jetty.client.api.Connection;
import ai.h2o.org.eclipse.jetty.client.api.ContentProvider;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.api.Result;
import ai.h2o.org.eclipse.jetty.client.util.BufferingResponseListener;
import ai.h2o.org.eclipse.jetty.http.HttpField;
import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.http.QuotedCSV;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 16384;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private static final Pattern PARAM_PATTERN = Pattern.compile("([^=]+)=([^=]+)?");
    private static final Pattern TYPE_PATTERN = Pattern.compile("([^\\s]+)(\\s+(.*))?");
    private static final Pattern MULTIPLE_CHALLENGE_PATTERN = Pattern.compile("(.*?)\\s*,\\s*([^=\\s,]+(\\s+[^=\\s].*)?)");
    private static final Pattern BASE64_PATTERN = Pattern.compile("[\\+\\-\\.\\/\\dA-Z_a-z~]+=*");
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;

    protected AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        this.client = client;
        this.maxContentLength = maxContentLength;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    protected abstract String getAuthenticationAttribute();

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    protected List<Authentication.HeaderInfo> getHeaderInfo(String value) throws IllegalArgumentException {
        Matcher m4;
        String header = value;
        ArrayList<Authentication.HeaderInfo> headerInfos = new ArrayList<Authentication.HeaderInfo>();
        while ((m4 = MULTIPLE_CHALLENGE_PATTERN.matcher(header)).matches()) {
            headerInfos.add(this.newHeaderInfo(m4.group(1)));
            header = m4.group(2);
        }
        headerInfos.add(this.newHeaderInfo(header));
        return headerInfos;
    }

    protected Authentication.HeaderInfo newHeaderInfo(String value) throws IllegalArgumentException {
        String type;
        HashMap<String, String> params = new HashMap();
        Matcher m4 = TYPE_PATTERN.matcher(value);
        if (m4.matches()) {
            type = m4.group(1);
            if (m4.group(2) != null) {
                params = this.parseParameters(m4.group(3));
            }
        } else {
            throw new IllegalArgumentException("Invalid Authentication Format");
        }
        return new Authentication.HeaderInfo(this.getAuthorizationHeader(), type, params);
    }

    protected Map<String, String> parseParameters(String wwwAuthenticate) throws IllegalArgumentException {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher b64 = BASE64_PATTERN.matcher(wwwAuthenticate);
        if (b64.matches()) {
            result.put("base64", wwwAuthenticate);
            return result;
        }
        QuotedCSV parts = new QuotedCSV(false, wwwAuthenticate);
        for (String part : parts) {
            Matcher params = PARAM_PATTERN.matcher(part);
            if (params.matches()) {
                String name = StringUtil.asciiToLowerCase(params.group(1));
                String value = params.group(2) == null ? "" : params.group(2);
                result.put(name, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid Authentication Format");
        }
        return result;
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result) {
            HttpRequest request2 = (HttpRequest)result.getRequest();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result.getResponseFailure() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", result.getFailure());
                }
                this.forwardFailureComplete(request2, result.getRequestFailure(), response, result.getResponseFailure());
                return;
            }
            String authenticationAttribute = AuthenticationProtocolHandler.this.getAuthenticationAttribute();
            HttpConversation conversation = request2.getConversation();
            if (conversation.getAttribute(authenticationAttribute) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", request2);
                }
                this.forwardSuccessComplete(request2, response);
                return;
            }
            HttpHeader header = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> headerInfos = this.parseAuthenticateHeader(response, header);
            if (headerInfos.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{header});
                }
                this.forwardFailureComplete(request2, result.getRequestFailure(), response, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + (Object)((Object)header) + " header", response));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo headerInfo = null;
            URI authURI = this.resolveURI(request2, AuthenticationProtocolHandler.this.getAuthenticationURI(request2));
            if (authURI != null) {
                for (Authentication.HeaderInfo element : headerInfos) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(element.getType(), authURI, element.getRealm());
                    if (authentication == null) continue;
                    headerInfo = element;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", request2);
                }
                this.forwardSuccessComplete(request2, response);
                return;
            }
            ContentProvider requestContent = request2.getContent();
            if (requestContent != null && !requestContent.isReproducible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content not reproducible for {}", request2);
                }
                this.forwardSuccessComplete(request2, response);
                return;
            }
            try {
                Authentication.Result authnResult = authentication.authenticate(request2, response, headerInfo, conversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", authnResult);
                }
                if (authnResult == null) {
                    this.forwardSuccessComplete(request2, response);
                    return;
                }
                conversation.setAttribute(authenticationAttribute, true);
                URI requestURI = request2.getURI();
                String path = null;
                if (requestURI == null) {
                    requestURI = this.resolveURI(request2, null);
                    path = request2.getPath();
                }
                Request newRequest = AuthenticationProtocolHandler.this.client.copyRequest(request2, requestURI);
                if (path != null) {
                    newRequest.path(path);
                }
                authnResult.apply(newRequest);
                this.copyIfAbsent(request2, newRequest, HttpHeader.AUTHORIZATION);
                this.copyIfAbsent(request2, newRequest, HttpHeader.PROXY_AUTHORIZATION);
                newRequest.onResponseSuccess(r2 -> AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(authnResult));
                Connection connection = (Connection)request2.getAttributes().get(Connection.class.getName());
                if (connection != null) {
                    connection.send(newRequest, null);
                } else {
                    newRequest.send(null);
                }
            }
            catch (Throwable x2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", x2);
                }
                this.forwardFailureComplete(request2, null, response, x2);
            }
        }

        private URI resolveURI(HttpRequest request2, URI uri) {
            if (uri != null) {
                return uri;
            }
            String target = request2.getScheme() + "://" + request2.getHost();
            int port = request2.getPort();
            if (port > 0) {
                target = target + ":" + port;
            }
            return URI.create(target);
        }

        private void copyIfAbsent(HttpRequest oldRequest, Request newRequest, HttpHeader header) {
            HttpField field = oldRequest.getHeaders().getField(header);
            if (field != null && !newRequest.getHeaders().contains(header)) {
                newRequest.getHeaders().put(field);
            }
        }

        private void forwardSuccessComplete(HttpRequest request2, Response response) {
            HttpConversation conversation = request2.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(conversation.getResponseListeners(), request2, response);
        }

        private void forwardFailureComplete(HttpRequest request2, Throwable requestFailure, Response response, Throwable responseFailure) {
            HttpConversation conversation = request2.getConversation();
            conversation.updateResponseListeners(null);
            List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
            if (responseFailure == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccess(responseListeners, response);
            } else {
                AuthenticationProtocolHandler.this.notifier.forwardFailure(responseListeners, response, responseFailure);
            }
            AuthenticationProtocolHandler.this.notifier.notifyComplete(responseListeners, new Result(request2, requestFailure, response, responseFailure));
        }

        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response, HttpHeader header) {
            ArrayList<Authentication.HeaderInfo> result = new ArrayList<Authentication.HeaderInfo>();
            List<String> values = response.getHeaders().getValuesList(header);
            for (String value : values) {
                try {
                    result.addAll(AuthenticationProtocolHandler.this.getHeaderInfo(value));
                }
                catch (IllegalArgumentException e2) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to parse authentication header", e2);
                }
            }
            return result;
        }
    }
}

