/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.HttpContentResponse;
import ai.h2o.org.eclipse.jetty.client.HttpConversation;
import ai.h2o.org.eclipse.jetty.client.HttpExchange;
import ai.h2o.org.eclipse.jetty.client.HttpRequest;
import ai.h2o.org.eclipse.jetty.client.HttpRequestException;
import ai.h2o.org.eclipse.jetty.client.ProtocolHandler;
import ai.h2o.org.eclipse.jetty.client.ResponseNotifier;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.api.Result;
import ai.h2o.org.eclipse.jetty.client.util.BufferingResponseListener;
import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.http.HttpHeaderValue;
import java.util.List;

public class ContinueProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "continue";
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final ResponseNotifier notifier = new ResponseNotifier();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request2, Response response) {
        boolean is100 = response.getStatus() == 100;
        boolean expect100 = request2.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        boolean handled100 = request2.getAttributes().containsKey(ATTRIBUTE);
        return (is100 || expect100) && !handled100;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected void onContinue(Request request2) {
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            Request request2 = response.getRequest();
            HttpConversation conversation = ((HttpRequest)request2).getConversation();
            request2.attribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            if (response.getStatus() == 100) {
                exchange.resetResponse();
                exchange.proceed(null);
                ContinueProtocolHandler.this.onContinue(request2);
            } else {
                List<Response.ResponseListener> listeners = exchange.getResponseListeners();
                HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                ContinueProtocolHandler.this.notifier.forwardSuccess(listeners, contentResponse);
                exchange.proceed(new HttpRequestException("Expectation failed", request2));
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(listeners, exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

