/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.HttpChannel;
import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.client.HttpDestination;
import ai.h2o.org.eclipse.jetty.client.HttpExchange;
import ai.h2o.org.eclipse.jetty.client.HttpProxy;
import ai.h2o.org.eclipse.jetty.client.HttpRequest;
import ai.h2o.org.eclipse.jetty.client.HttpRequestException;
import ai.h2o.org.eclipse.jetty.client.ProxyConfiguration;
import ai.h2o.org.eclipse.jetty.client.SendFailure;
import ai.h2o.org.eclipse.jetty.client.api.Authentication;
import ai.h2o.org.eclipse.jetty.client.api.Connection;
import ai.h2o.org.eclipse.jetty.client.api.ContentProvider;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.http.HttpFields;
import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.http.HttpVersion;
import ai.h2o.org.eclipse.jetty.util.HttpCookieStore;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class HttpConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final HttpDestination destination;
    private int idleTimeoutGuard;
    private long idleTimeoutStamp;

    protected HttpConnection(HttpDestination destination) {
        this.destination = destination;
        this.idleTimeoutStamp = System.nanoTime();
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    @Override
    public void send(Request request2, Response.CompleteListener listener) {
        HttpExchange exchange;
        SendFailure result;
        HttpRequest httpRequest = (HttpRequest)request2;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(httpRequest.getResponseListeners());
        httpRequest.sent();
        if (listener != null) {
            listeners.add(listener);
        }
        if ((result = this.send(exchange = new HttpExchange(this.getHttpDestination(), httpRequest, listeners))) != null) {
            httpRequest.abort(result.failure);
        }
    }

    protected abstract SendFailure send(HttpExchange var1);

    protected void normalizeRequest(Request request2) {
        CookieStore cookieStore;
        HttpVersion version = request2.getVersion();
        HttpFields headers = request2.getHeaders();
        ContentProvider content = request2.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String path = request2.getPath();
        if (path.trim().length() == 0) {
            path = "/";
            request2.path(path);
        }
        URI uri = request2.getURI();
        if (proxy instanceof HttpProxy && !HttpClient.isSchemeSecure(request2.getScheme()) && uri != null) {
            path = uri.toString();
            request2.path(path);
        }
        if (version.getVersion() <= 11 && !headers.containsKey(HttpHeader.HOST.asString())) {
            headers.put(this.getHttpDestination().getHostField());
        }
        if (content != null) {
            long contentLength;
            if (!headers.containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                String contentType = null;
                if (content instanceof ContentProvider.Typed) {
                    contentType = ((ContentProvider.Typed)content).getContentType();
                }
                if (contentType != null) {
                    headers.put(HttpHeader.CONTENT_TYPE, contentType);
                } else {
                    contentType = this.getHttpClient().getDefaultRequestContentType();
                    if (contentType != null) {
                        headers.put(HttpHeader.CONTENT_TYPE, contentType);
                    }
                }
            }
            if ((contentLength = content.getLength()) >= 0L && !headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            }
        }
        if ((cookieStore = this.getHttpClient().getCookieStore()) != null) {
            StringBuilder cookies = null;
            if (uri != null) {
                cookies = this.convertCookies(HttpCookieStore.matchPath(uri, cookieStore.get(uri)), null);
            }
            if ((cookies = this.convertCookies(request2.getCookies(), cookies)) != null) {
                request2.header(HttpHeader.COOKIE.asString(), cookies.toString());
            }
        }
        this.applyAuthentication(request2, proxy != null ? proxy.getURI() : null);
        this.applyAuthentication(request2, uri);
    }

    private StringBuilder convertCookies(List<HttpCookie> cookies, StringBuilder builder) {
        for (HttpCookie cookie : cookies) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append("; ");
            }
            builder.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        return builder;
    }

    private void applyAuthentication(Request request2, URI uri) {
        Authentication.Result result;
        if (uri != null && (result = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(uri)) != null) {
            result.apply(request2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendFailure send(HttpChannel channel, HttpExchange exchange) {
        boolean send;
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            boolean bl = send = this.idleTimeoutGuard >= 0;
            if (send) {
                ++this.idleTimeoutGuard;
            }
        }
        if (send) {
            SendFailure result;
            HttpRequest request2 = exchange.getRequest();
            if (channel.associate(exchange)) {
                channel.send();
                result = null;
            } else {
                channel.release();
                result = new SendFailure(new HttpRequestException("Could not associate request to connection", request2), false);
            }
            HttpConnection httpConnection2 = this;
            synchronized (httpConnection2) {
                --this.idleTimeoutGuard;
                this.idleTimeoutStamp = System.nanoTime();
            }
            return result;
        }
        return new SendFailure(new TimeoutException(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onIdleTimeout(long idleTimeout) {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.idleTimeoutGuard == 0) {
                boolean idle;
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.idleTimeoutStamp);
                boolean bl = idle = elapsed > idleTimeout / 2L;
                if (idle) {
                    this.idleTimeoutGuard = -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Idle timeout {}/{}ms - {}", elapsed, idleTimeout, this);
                }
                return idle;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout skipped - {}", this);
            }
            return false;
        }
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }
}

