/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.ProtocolHandler;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProtocolHandlers {
    private final Map<String, ProtocolHandler> handlers = new LinkedHashMap<String, ProtocolHandler>();

    protected ProtocolHandlers() {
    }

    public ProtocolHandler put(ProtocolHandler protocolHandler) {
        return this.handlers.put(protocolHandler.getName(), protocolHandler);
    }

    public ProtocolHandler remove(String name) {
        return this.handlers.remove(name);
    }

    public void clear() {
        this.handlers.clear();
    }

    public ProtocolHandler find(Request request2, Response response) {
        for (ProtocolHandler handler : this.handlers.values()) {
            if (!handler.accept(request2, response)) continue;
            return handler;
        }
        return null;
    }
}

