/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.AuthenticationProtocolHandler;
import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.client.HttpDestination;
import ai.h2o.org.eclipse.jetty.client.ProxyConfiguration;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import java.net.URI;

public class ProxyAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    public static final String NAME = "proxy-authenticate";
    private static final String ATTRIBUTE = ProxyAuthenticationProtocolHandler.class.getName() + ".attribute";

    public ProxyAuthenticationProtocolHandler(HttpClient client) {
        this(client, 16384);
    }

    public ProxyAuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        super(client, maxContentLength);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request2, Response response) {
        return response.getStatus() == 407;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.PROXY_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.PROXY_AUTHORIZATION;
    }

    @Override
    protected URI getAuthenticationURI(Request request2) {
        HttpDestination destination = this.getHttpClient().destinationFor(request2.getScheme(), request2.getHost(), request2.getPort());
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        return proxy != null ? proxy.getURI() : request2.getURI();
    }

    @Override
    protected String getAuthenticationAttribute() {
        return ATTRIBUTE;
    }
}

