/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.api.ContentResponse;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.api.Result;
import ai.h2o.org.eclipse.jetty.http.HttpField;
import ai.h2o.org.eclipse.jetty.util.Callback;
import ai.h2o.org.eclipse.jetty.util.CountingCallback;
import ai.h2o.org.eclipse.jetty.util.IteratingCallback;
import ai.h2o.org.eclipse.jetty.util.IteratingNestedCallback;
import ai.h2o.org.eclipse.jetty.util.Retainable;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response, HttpField field) {
        boolean result = true;
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.HeaderListener)) continue;
            result &= this.notifyHeader((Response.HeaderListener)listener, response, field);
        }
        return result;
    }

    private boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            return listener.onHeader(response, field);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public void notifyContent(List<Response.ResponseListener> listeners, Response response, ByteBuffer buffer, Callback callback) {
        List<Response.AsyncContentListener> contentListeners = listeners.stream().filter(Response.AsyncContentListener.class::isInstance).map(Response.AsyncContentListener.class::cast).collect(Collectors.toList());
        this.notifyContent(response, buffer, callback, contentListeners);
    }

    public void notifyContent(Response response, ByteBuffer buffer, Callback callback, List<Response.AsyncContentListener> contentListeners) {
        if (contentListeners.isEmpty()) {
            callback.succeeded();
        } else {
            CountingCallback counter = new CountingCallback(callback, contentListeners.size());
            Retainable retainable = callback instanceof Retainable ? (Retainable)((Object)callback) : null;
            for (Response.AsyncContentListener listener : contentListeners) {
                ByteBuffer slice2 = buffer.slice();
                if (retainable != null) {
                    retainable.retain();
                }
                listener.onContent(response, slice2, counter);
            }
        }
    }

    private void notifyContent(Response.AsyncContentListener listener, Response response, ByteBuffer buffer, Callback callback) {
        try {
            listener.onContent(response, buffer, callback);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            listener.onFailure(response, failure);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            Response.ResponseListener listener = listeners.get(i2);
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
        }
        catch (Throwable x2) {
            LOG.info("Exception while notifying listener " + listener, x2);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        this.notifyBegin(listeners, response);
        Iterator<HttpField> iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()), Callback.NOOP);
        }
        this.notifySuccess(listeners, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request2, Response response) {
        this.forwardSuccess(listeners, response);
        this.notifyComplete(listeners, new Result(request2, response));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        this.notifyBegin(listeners, response);
        Iterator<HttpField> iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()), Callback.NOOP);
        }
        this.notifyFailure(listeners, response, failure);
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request2, Throwable requestFailure, Response response, Throwable responseFailure) {
        this.forwardFailure(listeners, response, responseFailure);
        this.notifyComplete(listeners, new Result(request2, requestFailure, response, responseFailure));
    }

    private class ContentCallback
    extends IteratingNestedCallback {
        private final List<Response.ResponseListener> listeners;
        private final Response response;
        private final ByteBuffer buffer;
        private int index;

        private ContentCallback(List<Response.ResponseListener> listeners, Response response, ByteBuffer buffer, Callback callback) {
            super(callback);
            this.listeners = listeners;
            this.response = response;
            this.buffer = buffer.slice();
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.index == this.listeners.size()) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            Response.ResponseListener listener = this.listeners.get(this.index);
            if (listener instanceof Response.AsyncContentListener) {
                this.buffer.clear();
                ResponseNotifier.this.notifyContent((Response.AsyncContentListener)listener, this.response, this.buffer, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            this.succeeded();
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        public void succeeded() {
            ++this.index;
            super.succeeded();
        }
    }
}

