/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client;

import ai.h2o.org.eclipse.jetty.client.HttpRequest;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.api.Result;
import ai.h2o.org.eclipse.jetty.io.CyclicTimeout;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class TimeoutCompleteListener
extends CyclicTimeout
implements Response.CompleteListener {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Request> request = new AtomicReference();

    public TimeoutCompleteListener(Scheduler scheduler) {
        super(scheduler);
    }

    @Override
    public void onTimeoutExpired() {
        Request request2 = this.request.getAndSet(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total timeout {} ms elapsed for {}", request2.getTimeout(), request2);
        }
        if (request2 != null) {
            request2.abort(new TimeoutException("Total timeout " + request2.getTimeout() + " ms elapsed"));
        }
    }

    @Override
    public void onComplete(Result result) {
        Request request2 = this.request.getAndSet(null);
        if (request2 != null) {
            boolean cancelled = this.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) timeout for {}", cancelled, request2);
            }
        }
    }

    void schedule(HttpRequest request2, long timeoutAt) {
        if (this.request.compareAndSet(null, request2)) {
            long delay = timeoutAt - System.nanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled timeout in {} ms for {}", TimeUnit.NANOSECONDS.toMillis(delay), request2);
            }
            if (delay <= 0L) {
                this.onTimeoutExpired();
            } else {
                this.schedule(delay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

