/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.client.http;

import ai.h2o.org.eclipse.jetty.client.HttpConnection;
import ai.h2o.org.eclipse.jetty.client.HttpDestination;
import ai.h2o.org.eclipse.jetty.client.HttpExchange;
import ai.h2o.org.eclipse.jetty.client.HttpRequest;
import ai.h2o.org.eclipse.jetty.client.SendFailure;
import ai.h2o.org.eclipse.jetty.client.api.Connection;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import ai.h2o.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import ai.h2o.org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import ai.h2o.org.eclipse.jetty.io.AbstractConnection;
import ai.h2o.org.eclipse.jetty.io.Connection;
import ai.h2o.org.eclipse.jetty.io.EndPoint;
import ai.h2o.org.eclipse.jetty.util.Promise;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.util.thread.Sweeper;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection,
Connection.UpgradeFrom,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor());
        this.promise = promise;
        this.delegate = new Delegate(destination);
        this.channel = this.newHttpChannel();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    protected void addBytesIn(long bytesIn) {
        this.bytesIn.add(bytesIn);
    }

    @Override
    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    protected void addBytesOut(long bytesOut) {
        this.bytesOut.add(bytesOut);
    }

    @Override
    public long getMessagesIn() {
        return this.getHttpChannel().getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.getHttpChannel().getMessagesOut();
    }

    @Override
    public void send(Request request2, Response.CompleteListener listener) {
        this.delegate.send(request2, listener);
    }

    protected SendFailure send(HttpExchange exchange) {
        return this.delegate.send(exchange);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean onIdleExpired() {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean close = this.delegate.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("Idle timeout " + idleTimeout + " ms"));
        }
        return false;
    }

    @Override
    public void onFillable() {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            this.channel.receive();
        } else {
            this.close();
        }
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        HttpReceiverOverHTTP receiver = this.channel.getHttpReceiver();
        return receiver.onUpgradeFrom();
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close(this);
            this.abort(failure);
            this.channel.destroy();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", this);
            }
        }
    }

    protected boolean abort(Throwable failure) {
        HttpExchange exchange = this.channel.getHttpExchange();
        return exchange != null && exchange.getRequest().abort(failure);
    }

    @Override
    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public void remove() {
        this.getHttpDestination().remove(this);
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x(l:%s <-> r:%s,closed=%b)=>%s", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.closed.get(), this.channel);
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected SendFailure send(HttpExchange exchange) {
            HttpRequest request2 = exchange.getRequest();
            this.normalizeRequest(request2);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            endPoint.setIdleTimeout(request2.getIdleTimeout());
            return this.send(HttpConnectionOverHTTP.this.channel, exchange);
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
        }

        @Override
        public boolean isClosed() {
            return HttpConnectionOverHTTP.this.isClosed();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

