/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.http;

import ai.h2o.org.eclipse.jetty.http.HttpField;
import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.http.PreEncodedHttpField;
import ai.h2o.org.eclipse.jetty.util.ArrayTrie;
import ai.h2o.org.eclipse.jetty.util.BufferUtil;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.Trie;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MimeTypes {
    private static final Logger LOG;
    private static final Trie<ByteBuffer> TYPES;
    private static final Map<String, String> __dftMimeMap;
    private static final Map<String, String> __inferredEncodings;
    private static final Map<String, String> __assumedEncodings;
    public static final Trie<Type> CACHE;
    private final Map<String, String> _mimeMap = new HashMap<String, String>();

    public synchronized Map<String, String> getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map<String, String> mimeMap) {
        this._mimeMap.clear();
        if (mimeMap != null) {
            for (Map.Entry<String, String> ext : mimeMap.entrySet()) {
                this._mimeMap.put(StringUtil.asciiToLowerCase(ext.getKey()), MimeTypes.normalizeMimeType(ext.getValue()));
            }
        }
    }

    public static String getDefaultMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i2 = -1;
            while (type == null && (i2 = filename.indexOf(".", i2 + 1)) >= 0 && i2 < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i2 + 1));
                if (type != null) continue;
                type = __dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            type = __dftMimeMap.get("*");
        }
        return type;
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i2 = -1;
            while (type == null && (i2 = filename.indexOf(".", i2 + 1)) >= 0 && i2 < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i2 + 1));
                if (this._mimeMap != null) {
                    type = this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = __dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = this._mimeMap.get("*");
            }
            if (type == null) {
                type = __dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    public static Set<String> getKnownMimeTypes() {
        return new HashSet<String>(__dftMimeMap.values());
    }

    private static String normalizeMimeType(String type) {
        Type t2 = CACHE.get(type);
        if (t2 != null) {
            return t2.asString();
        }
        return StringUtil.asciiToLowerCase(type);
    }

    public static String getCharsetFromContentType(String value) {
        int i2;
        if (value == null) {
            return null;
        }
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        block13: for (i2 = 0; i2 < end; ++i2) {
            char b2 = value.charAt(i2);
            if (quote && state != 10) {
                if ('\"' != b2) continue;
                quote = false;
                continue;
            }
            if (';' == b2 && state <= 8) {
                state = 1;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\"' != b2) continue block13;
                    quote = true;
                    continue block13;
                }
                case 1: {
                    if ('c' == b2) {
                        state = 2;
                        continue block13;
                    }
                    if (' ' == b2) continue block13;
                    state = 0;
                    continue block13;
                }
                case 2: {
                    if ('h' == b2) {
                        state = 3;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 3: {
                    if ('a' == b2) {
                        state = 4;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 4: {
                    if ('r' == b2) {
                        state = 5;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 5: {
                    if ('s' == b2) {
                        state = 6;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 6: {
                    if ('e' == b2) {
                        state = 7;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 7: {
                    if ('t' == b2) {
                        state = 8;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 8: {
                    if ('=' == b2) {
                        state = 9;
                        continue block13;
                    }
                    if (' ' == b2) continue block13;
                    state = 0;
                    continue block13;
                }
                case 9: {
                    if (' ' == b2) continue block13;
                    if ('\"' == b2) {
                        quote = true;
                        start = i2 + 1;
                        state = 10;
                        continue block13;
                    }
                    start = i2;
                    state = 10;
                    continue block13;
                }
                case 10: {
                    if ((quote || ';' != b2 && ' ' != b2) && (!quote || '\"' != b2)) continue block13;
                    return StringUtil.normalizeCharset(value, start, i2 - start);
                }
            }
        }
        if (state == 10) {
            return StringUtil.normalizeCharset(value, start, i2 - start);
        }
        return null;
    }

    public static Map<String, String> getInferredEncodings() {
        return __inferredEncodings;
    }

    public static Map<String, String> getAssumedEncodings() {
        return __inferredEncodings;
    }

    @Deprecated
    public static String inferCharsetFromContentType(String contentType) {
        return MimeTypes.getCharsetAssumedFromContentType(contentType);
    }

    public static String getCharsetInferredFromContentType(String contentType) {
        return __inferredEncodings.get(contentType);
    }

    public static String getCharsetAssumedFromContentType(String contentType) {
        return __assumedEncodings.get(contentType);
    }

    public static String getContentTypeWithoutCharset(String value) {
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        StringBuilder builder = null;
        block19: for (int i2 = 0; i2 < end; ++i2) {
            char b2 = value.charAt(i2);
            if ('\"' == b2) {
                quote = !quote;
                switch (state) {
                    case 11: {
                        builder.append(b2);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    default: {
                        start = i2;
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (quote) {
                if (builder == null || state == 10) continue;
                builder.append(b2);
                continue;
            }
            switch (state) {
                case 0: {
                    if (';' == b2) {
                        state = 1;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    start = i2;
                    continue block19;
                }
                case 1: {
                    if ('c' == b2) {
                        state = 2;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    if ('h' == b2) {
                        state = 3;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 3: {
                    if ('a' == b2) {
                        state = 4;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if ('r' == b2) {
                        state = 5;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 5: {
                    if ('s' == b2) {
                        state = 6;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 6: {
                    if ('e' == b2) {
                        state = 7;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 7: {
                    if ('t' == b2) {
                        state = 8;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 8: {
                    if ('=' == b2) {
                        state = 9;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    state = 0;
                    continue block19;
                }
                case 9: {
                    if (' ' == b2) continue block19;
                    builder = new StringBuilder();
                    builder.append(value, 0, start + 1);
                    state = 10;
                    continue block19;
                }
                case 10: {
                    if (';' != b2) continue block19;
                    builder.append(b2);
                    state = 11;
                    continue block19;
                }
                case 11: {
                    if (' ' == b2) continue block19;
                    builder.append(b2);
                }
            }
        }
        if (builder == null) {
            return value;
        }
        return builder.toString();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        block41: {
            Properties props2;
            InputStreamReader reader;
            InputStream stream;
            String resourceName;
            block40: {
                LOG = Log.getLogger(MimeTypes.class);
                TYPES = new ArrayTrie<ByteBuffer>(512);
                __dftMimeMap = new HashMap<String, String>();
                __inferredEncodings = new HashMap<String, String>();
                __assumedEncodings = new HashMap<String, String>();
                CACHE = new ArrayTrie<Type>(512);
                for (Type type : Type.values()) {
                    CACHE.put(type.toString(), type);
                    TYPES.put(type.toString(), type.asBuffer());
                    int charset = type.toString().indexOf(";charset=");
                    if (charset > 0) {
                        String alt = type.toString().replace(";charset=", "; charset=");
                        CACHE.put(alt, type);
                        TYPES.put(alt, type.asBuffer());
                    }
                    if (!type.isCharsetAssumed()) continue;
                    __assumedEncodings.put(type.asString(), type.getCharsetString());
                }
                resourceName = "ai/h2o/org/eclipse/jetty/http/mime.properties";
                try {
                    stream = MimeTypes.class.getClassLoader().getResourceAsStream(resourceName);
                    Throwable throwable = null;
                    try {
                        if (stream == null) {
                            LOG.warn("Missing mime-type resource: {}", resourceName);
                            break block40;
                        }
                        try {
                            reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                            Throwable throwable2 = null;
                            try {
                                props2 = new Properties();
                                props2.load(reader);
                                props2.stringPropertyNames().stream().filter(x2 -> x2 != null).forEach(x2 -> __dftMimeMap.put(StringUtil.asciiToLowerCase(x2), MimeTypes.normalizeMimeType(props2.getProperty((String)x2))));
                                if (__dftMimeMap.size() == 0) {
                                    LOG.warn("Empty mime types at {}", resourceName);
                                } else if (__dftMimeMap.size() < props2.keySet().size()) {
                                    LOG.warn("Duplicate or null mime-type extension in resource: {}", resourceName);
                                }
                            }
                            catch (Throwable props2) {
                                throwable2 = props2;
                                throw props2;
                            }
                            finally {
                                MimeTypes.$closeResource(throwable2, reader);
                            }
                        }
                        catch (IOException e2) {
                            LOG.warn(e2.toString(), new Object[0]);
                            LOG.debug(e2);
                        }
                    }
                    catch (Throwable e2) {
                        throwable = e2;
                        throw e2;
                    }
                    finally {
                        if (stream != null) {
                            MimeTypes.$closeResource(throwable, stream);
                        }
                    }
                }
                catch (IOException e3) {
                    LOG.warn(e3.toString(), new Object[0]);
                    LOG.debug(e3);
                }
            }
            resourceName = "ai/h2o/org/eclipse/jetty/http/encoding.properties";
            try {
                stream = MimeTypes.class.getClassLoader().getResourceAsStream(resourceName);
                Throwable throwable = null;
                try {
                    if (stream == null) {
                        LOG.warn("Missing encoding resource: {}", resourceName);
                        break block41;
                    }
                    try {
                        reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        Throwable throwable3 = null;
                        try {
                            props2 = new Properties();
                            props2.load(reader);
                            props2.stringPropertyNames().stream().filter(t2 -> t2 != null).forEach(t2 -> {
                                String charset = props2.getProperty((String)t2);
                                if (charset.startsWith("-")) {
                                    __assumedEncodings.put((String)t2, charset.substring(1));
                                } else {
                                    __inferredEncodings.put((String)t2, props2.getProperty((String)t2));
                                }
                            });
                            if (__inferredEncodings.size() == 0) {
                                LOG.warn("Empty encodings at {}", resourceName);
                            } else if (__inferredEncodings.size() + __assumedEncodings.size() < props2.keySet().size()) {
                                LOG.warn("Null or duplicate encodings in resource: {}", resourceName);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            MimeTypes.$closeResource(throwable3, reader);
                        }
                    }
                    catch (IOException e4) {
                        LOG.warn(e4.toString(), new Object[0]);
                        LOG.debug(e4);
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream != null) {
                        MimeTypes.$closeResource(throwable, stream);
                    }
                }
            }
            catch (IOException e5) {
                LOG.warn(e5.toString(), new Object[0]);
                LOG.debug(e5);
            }
        }
    }

    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        TEXT_HTML("text/html"),
        TEXT_PLAIN("text/plain"),
        TEXT_XML("text/xml"),
        TEXT_JSON("text/json", StandardCharsets.UTF_8),
        APPLICATION_JSON("application/json", StandardCharsets.UTF_8),
        TEXT_HTML_8859_1("text/html;charset=iso-8859-1", TEXT_HTML),
        TEXT_HTML_UTF_8("text/html;charset=utf-8", TEXT_HTML),
        TEXT_PLAIN_8859_1("text/plain;charset=iso-8859-1", TEXT_PLAIN),
        TEXT_PLAIN_UTF_8("text/plain;charset=utf-8", TEXT_PLAIN),
        TEXT_XML_8859_1("text/xml;charset=iso-8859-1", TEXT_XML),
        TEXT_XML_UTF_8("text/xml;charset=utf-8", TEXT_XML),
        TEXT_JSON_8859_1("text/json;charset=iso-8859-1", TEXT_JSON),
        TEXT_JSON_UTF_8("text/json;charset=utf-8", TEXT_JSON),
        APPLICATION_JSON_8859_1("application/json;charset=iso-8859-1", APPLICATION_JSON),
        APPLICATION_JSON_UTF_8("application/json;charset=utf-8", APPLICATION_JSON);

        private final String _string;
        private final Type _base;
        private final ByteBuffer _buffer;
        private final Charset _charset;
        private final String _charsetString;
        private final boolean _assumedCharset;
        private final HttpField _field;

        private Type(String s2) {
            this._string = s2;
            this._buffer = BufferUtil.toBuffer(s2);
            this._base = this;
            this._charset = null;
            this._charsetString = null;
            this._assumedCharset = false;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String s2, Type base) {
            this._string = s2;
            this._buffer = BufferUtil.toBuffer(s2);
            this._base = base;
            int i2 = s2.indexOf(";charset=");
            this._charset = Charset.forName(s2.substring(i2 + 9));
            this._charsetString = this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = false;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String s2, Charset cs) {
            this._string = s2;
            this._base = this;
            this._buffer = BufferUtil.toBuffer(s2);
            this._charset = cs;
            this._charsetString = this._charset == null ? null : this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = true;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        public ByteBuffer asBuffer() {
            return this._buffer.asReadOnlyBuffer();
        }

        public Charset getCharset() {
            return this._charset;
        }

        public String getCharsetString() {
            return this._charsetString;
        }

        public boolean is(String s2) {
            return this._string.equalsIgnoreCase(s2);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }

        public boolean isCharsetAssumed() {
            return this._assumedCharset;
        }

        public HttpField getContentTypeField() {
            return this._field;
        }

        public Type getBaseType() {
            return this._base;
        }
    }
}

