/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.http;

import java.util.Objects;

public final class Syntax {
    public static void requireValidRFC2616Token(String value, String msg) {
        Objects.requireNonNull(msg, "msg cannot be null");
        if (value == null) {
            return;
        }
        int valueLen = value.length();
        if (valueLen == 0) {
            return;
        }
        for (int i2 = 0; i2 < valueLen; ++i2) {
            char c2 = value.charAt(i2);
            if (c2 <= '\u001f' || c2 == '\u007f') {
                throw new IllegalArgumentException(msg + ": RFC2616 tokens may not contain control characters");
            }
            if (c2 == '(' || c2 == ')' || c2 == '<' || c2 == '>' || c2 == '@' || c2 == ',' || c2 == ';' || c2 == ':' || c2 == '\\' || c2 == '\"' || c2 == '/' || c2 == '[' || c2 == ']' || c2 == '?' || c2 == '=' || c2 == '{' || c2 == '}' || c2 == ' ') {
                throw new IllegalArgumentException(msg + ": RFC2616 tokens may not contain separator character: [" + c2 + "]");
            }
            if (c2 < '\u0080') continue;
            throw new IllegalArgumentException(msg + ": RFC2616 tokens characters restricted to US-ASCII: 0x" + Integer.toHexString(c2));
        }
    }

    public static void requireValidRFC6265CookieValue(String value) {
        if (value == null) {
            return;
        }
        int valueLen = value.length();
        if (valueLen == 0) {
            return;
        }
        int i2 = 0;
        if (value.charAt(0) == '\"') {
            if (valueLen <= 1 || value.charAt(valueLen - 1) != '\"') {
                throw new IllegalArgumentException("RFC6265 Cookie values must have balanced DQUOTES (if used)");
            }
            ++i2;
            --valueLen;
        }
        while (i2 < valueLen) {
            char c2 = value.charAt(i2);
            if (c2 <= '\u001f' || c2 == '\u007f') {
                throw new IllegalArgumentException("RFC6265 Cookie values may not contain control characters");
            }
            if (c2 == ' ' || c2 == '\"' || c2 == ';' || c2 == '\\') {
                throw new IllegalArgumentException("RFC6265 Cookie values may not contain character: [" + c2 + "]");
            }
            if (c2 >= '\u0080') {
                throw new IllegalArgumentException("RFC6265 Cookie values characters restricted to US-ASCII: 0x" + Integer.toHexString(c2));
            }
            ++i2;
        }
    }
}

