/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.jaas.callback;

import ai.h2o.org.eclipse.jetty.jaas.callback.AbstractCallbackHandler;
import ai.h2o.org.eclipse.jetty.jaas.callback.ObjectCallback;
import ai.h2o.org.eclipse.jetty.jaas.callback.RequestParameterCallback;
import ai.h2o.org.eclipse.jetty.jaas.callback.ServletRequestCallback;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.util.security.Password;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request2) {
        this._request = request2;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i2 = 0; i2 < callbacks.length; ++i2) {
            if (callbacks[i2] instanceof NameCallback) {
                ((NameCallback)callbacks[i2]).setName(this.getUserName());
                continue;
            }
            if (callbacks[i2] instanceof ObjectCallback) {
                ((ObjectCallback)callbacks[i2]).setObject(this.getCredential());
                continue;
            }
            if (callbacks[i2] instanceof PasswordCallback) {
                if (this.getCredential() instanceof Password) {
                    ((PasswordCallback)callbacks[i2]).setPassword(((Password)this.getCredential()).toString().toCharArray());
                    continue;
                }
                if (this.getCredential() instanceof String) {
                    ((PasswordCallback)callbacks[i2]).setPassword(((String)this.getCredential()).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i2], "User supplied credentials cannot be converted to char[] for PasswordCallback: try using an ObjectCallback instead");
            }
            if (callbacks[i2] instanceof RequestParameterCallback) {
                RequestParameterCallback callback = (RequestParameterCallback)callbacks[i2];
                callback.setParameterValues(Arrays.asList(this._request.getParameterValues(callback.getParameterName())));
                continue;
            }
            if (callbacks[i2] instanceof ServletRequestCallback) {
                ((ServletRequestCallback)callbacks[i2]).setRequest(this._request);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i2]);
        }
    }
}

