/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.jaas.spi;

import ai.h2o.org.eclipse.jetty.jaas.JAASPrincipal;
import ai.h2o.org.eclipse.jetty.jaas.JAASRole;
import ai.h2o.org.eclipse.jetty.jaas.callback.ObjectCallback;
import ai.h2o.org.eclipse.jetty.jaas.spi.UserInfo;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class AbstractLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private boolean authState = false;
    private boolean commitState = false;
    private JAASUserInfo currentUser;
    private Subject subject;

    public abstract UserInfo getUserInfo(String var1) throws Exception;

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject s2) {
        this.subject = s2;
    }

    public JAASUserInfo getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(JAASUserInfo u2) {
        this.currentUser = u2;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler h2) {
        this.callbackHandler = h2;
    }

    public boolean isAuthenticated() {
        return this.authState;
    }

    public boolean isCommitted() {
        return this.commitState;
    }

    public void setAuthenticated(boolean authState) {
        this.authState = authState;
    }

    public void setCommitted(boolean commitState) {
        this.commitState = commitState;
    }

    @Override
    public boolean abort() throws LoginException {
        this.currentUser = null;
        return this.isAuthenticated() && this.isCommitted();
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.currentUser = null;
            this.setCommitted(false);
            return false;
        }
        this.setCommitted(true);
        this.currentUser.setJAASInfo(this.subject);
        return true;
    }

    public Callback[] configureCallbacks() {
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new ObjectCallback(), new PasswordCallback("Enter password", false)};
        return callbacks;
    }

    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            if (this.isIgnored()) {
                return false;
            }
            if (this.callbackHandler == null) {
                throw new LoginException("No callback handler");
            }
            Callback[] callbacks = this.configureCallbacks();
            this.callbackHandler.handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = null;
            webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webCredential == null) {
                webCredential = ((PasswordCallback)callbacks[2]).getPassword();
            }
            if (webUserName == null || webCredential == null) {
                this.setAuthenticated(false);
                throw new FailedLoginException();
            }
            UserInfo userInfo = this.getUserInfo(webUserName);
            if (userInfo == null) {
                this.setAuthenticated(false);
                throw new FailedLoginException();
            }
            this.currentUser = new JAASUserInfo(userInfo);
            this.setAuthenticated(this.currentUser.checkCredential(webCredential));
            if (this.isAuthenticated()) {
                this.currentUser.fetchRoles();
                return true;
            }
            throw new FailedLoginException();
        }
        catch (IOException e2) {
            throw new LoginException(e2.toString());
        }
        catch (UnsupportedCallbackException e3) {
            throw new LoginException(e3.toString());
        }
        catch (Exception e4) {
            if (e4 instanceof LoginException) {
                throw (LoginException)e4;
            }
            throw new LoginException(e4.toString());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.currentUser.unsetJAASInfo(this.subject);
        this.currentUser = null;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    public class JAASUserInfo {
        private UserInfo user;
        private Principal principal;
        private List<JAASRole> roles;

        public JAASUserInfo(UserInfo u2) {
            this.user = u2;
            this.principal = new JAASPrincipal(u2.getUserName());
        }

        public String getUserName() {
            return this.user.getUserName();
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public void setJAASInfo(Subject subject) {
            subject.getPrincipals().add(this.principal);
            subject.getPrivateCredentials().add(this.user.getCredential());
            subject.getPrincipals().addAll(this.roles);
        }

        public void unsetJAASInfo(Subject subject) {
            subject.getPrincipals().remove(this.principal);
            subject.getPrivateCredentials().remove(this.user.getCredential());
            subject.getPrincipals().removeAll(this.roles);
        }

        public boolean checkCredential(Object suppliedCredential) {
            return this.user.checkCredential(suppliedCredential);
        }

        public void fetchRoles() throws Exception {
            this.user.fetchRoles();
            this.roles = new ArrayList<JAASRole>();
            if (this.user.getRoleNames() != null) {
                Iterator<String> itor = this.user.getRoleNames().iterator();
                while (itor.hasNext()) {
                    this.roles.add(new JAASRole(itor.next()));
                }
            }
        }
    }
}

