/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.jaas.spi;

import ai.h2o.org.eclipse.jetty.util.security.Credential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UserInfo {
    private String _userName;
    private Credential _credential;
    protected List<String> _roleNames = new ArrayList<String>();
    protected boolean _rolesLoaded = false;

    public UserInfo(String userName, Credential credential, List<String> roleNames) {
        this._userName = userName;
        this._credential = credential;
        if (roleNames != null) {
            this._roleNames.addAll(roleNames);
            this._rolesLoaded = true;
        }
    }

    public UserInfo(String userName, Credential credential) {
        this(userName, credential, null);
    }

    public List<String> doFetchRoles() throws Exception {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchRoles() throws Exception {
        List<String> list = this._roleNames;
        synchronized (list) {
            if (!this._rolesLoaded) {
                this._roleNames.addAll(this.doFetchRoles());
                this._rolesLoaded = true;
            }
        }
    }

    public String getUserName() {
        return this._userName;
    }

    public List<String> getRoleNames() {
        return Collections.unmodifiableList(this._roleNames);
    }

    public boolean checkCredential(Object suppliedCredential) {
        return this._credential.check(suppliedCredential);
    }

    protected Credential getCredential() {
        return this._credential;
    }
}

