/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.proxy;

import ai.h2o.org.eclipse.jetty.client.api.ContentProvider;
import ai.h2o.org.eclipse.jetty.client.api.Request;
import ai.h2o.org.eclipse.jetty.client.api.Response;
import ai.h2o.org.eclipse.jetty.client.util.DeferredContentProvider;
import ai.h2o.org.eclipse.jetty.proxy.AbstractProxyServlet;
import ai.h2o.org.eclipse.jetty.proxy.ProxyServlet;
import ai.h2o.org.eclipse.jetty.util.Callback;
import ai.h2o.org.eclipse.jetty.util.IteratingCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncProxyServlet
extends ProxyServlet {
    private static final String WRITE_LISTENER_ATTRIBUTE = AsyncProxyServlet.class.getName() + ".writeListener";

    @Override
    protected ContentProvider proxyRequestContent(HttpServletRequest request2, HttpServletResponse response, Request proxyRequest) throws IOException {
        ServletInputStream input = request2.getInputStream();
        DeferredContentProvider provider = new DeferredContentProvider(new ByteBuffer[0]);
        input.setReadListener(this.newReadListener(request2, response, proxyRequest, provider));
        return provider;
    }

    protected ReadListener newReadListener(HttpServletRequest request2, HttpServletResponse response, Request proxyRequest, DeferredContentProvider provider) {
        return new StreamReader(request2, response, proxyRequest, provider);
    }

    @Override
    protected void onResponseContent(HttpServletRequest request2, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            StreamWriter writeListener;
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} proxying content to downstream: {} bytes", this.getRequestId(request2), length);
            }
            if ((writeListener = (StreamWriter)request2.getAttribute(WRITE_LISTENER_ATTRIBUTE)) == null) {
                writeListener = this.newWriteListener(request2, proxyResponse);
                request2.setAttribute(WRITE_LISTENER_ATTRIBUTE, writeListener);
                writeListener.data(buffer, offset, length, callback);
                response.getOutputStream().setWriteListener(writeListener);
            } else {
                writeListener.data(buffer, offset, length, callback);
                writeListener.onWritePossible();
            }
        }
        catch (Throwable x2) {
            callback.failed(x2);
            proxyResponse.abort(x2);
        }
    }

    protected StreamWriter newWriteListener(HttpServletRequest request2, Response proxyResponse) {
        return new StreamWriter(request2, proxyResponse);
    }

    private static enum WriteState {
        READY,
        PENDING,
        IDLE;

    }

    protected class StreamWriter
    implements WriteListener {
        private final HttpServletRequest request;
        private final Response proxyResponse;
        private WriteState state;
        private byte[] buffer;
        private int offset;
        private int length;
        private Callback callback;

        protected StreamWriter(HttpServletRequest request2, Response proxyResponse) {
            this.request = request2;
            this.proxyResponse = proxyResponse;
            this.state = WriteState.IDLE;
        }

        protected void data(byte[] bytes, int offset, int length, Callback callback) {
            if (this.state != WriteState.IDLE) {
                throw new WritePendingException();
            }
            this.state = WriteState.READY;
            this.buffer = bytes;
            this.offset = offset;
            this.length = length;
            this.callback = callback;
        }

        @Override
        public void onWritePossible() throws IOException {
            int requestId = AsyncProxyServlet.this.getRequestId(this.request);
            ServletOutputStream output = this.request.getAsyncContext().getResponse().getOutputStream();
            if (this.state == WriteState.READY) {
                if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous write start of {} bytes on {}", requestId, this.length, output);
                }
                output.write(this.buffer, this.offset, this.length);
                this.state = WriteState.PENDING;
                if (output.isReady()) {
                    if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                        AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes completed on {}", requestId, this.length, output);
                    }
                    this.complete();
                } else if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes pending on {}", requestId, this.length, output);
                }
            } else if (this.state == WriteState.PENDING) {
                if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes completing on {}", requestId, this.length, output);
                }
                this.complete();
            } else {
                throw new IllegalStateException();
            }
        }

        protected void complete() {
            this.buffer = null;
            this.offset = 0;
            this.length = 0;
            Callback c2 = this.callback;
            this.callback = null;
            this.state = WriteState.IDLE;
            c2.succeeded();
        }

        @Override
        public void onError(Throwable failure) {
            this.proxyResponse.abort(failure);
        }
    }

    protected class StreamReader
    extends IteratingCallback
    implements ReadListener {
        private final byte[] buffer;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final Request proxyRequest;
        private final DeferredContentProvider provider;

        protected StreamReader(HttpServletRequest request2, HttpServletResponse response, Request proxyRequest, DeferredContentProvider provider) {
            this.buffer = new byte[AsyncProxyServlet.this.getHttpClient().getRequestBufferSize()];
            this.request = request2;
            this.response = response;
            this.proxyRequest = proxyRequest;
            this.provider = provider;
        }

        @Override
        public void onDataAvailable() throws IOException {
            this.iterate();
        }

        @Override
        public void onAllDataRead() throws IOException {
            if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                AsyncProxyServlet.this._log.debug("{} proxying content to upstream completed", AsyncProxyServlet.this.getRequestId(this.request));
            }
            this.provider.close();
        }

        @Override
        public void onError(Throwable t2) {
            AsyncProxyServlet.this.onClientRequestFailure(this.request, this.proxyRequest, this.response, t2);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            int requestId = AsyncProxyServlet.this._log.isDebugEnabled() ? AsyncProxyServlet.this.getRequestId(this.request) : 0;
            ServletInputStream input = this.request.getInputStream();
            while (input.isReady()) {
                int read = input.read(this.buffer);
                if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous read {} bytes on {}", requestId, read, input);
                }
                if (read > 0) {
                    if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                        AsyncProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", requestId, read);
                    }
                    this.onRequestContent(this.request, this.proxyRequest, this.provider, this.buffer, 0, read, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (read >= 0) continue;
                if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous read complete on {}", requestId, input);
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (AsyncProxyServlet.this._log.isDebugEnabled()) {
                AsyncProxyServlet.this._log.debug("{} asynchronous read pending on {}", requestId, input);
            }
            return IteratingCallback.Action.IDLE;
        }

        protected void onRequestContent(HttpServletRequest request2, Request proxyRequest, DeferredContentProvider provider, byte[] buffer, int offset, int length, Callback callback) {
            provider.offer(ByteBuffer.wrap(buffer, offset, length), callback);
        }

        @Override
        public void failed(Throwable x2) {
            super.failed(x2);
            this.onError(x2);
        }
    }

    public static class Transparent
    extends AsyncProxyServlet {
        private final AbstractProxyServlet.TransparentDelegate delegate = new AbstractProxyServlet.TransparentDelegate(this);

        @Override
        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected String rewriteTarget(HttpServletRequest clientRequest) {
            return this.delegate.rewriteTarget(clientRequest);
        }
    }
}

