/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.security.authentication;

import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.security.ServerAuthException;
import ai.h2o.org.eclipse.jetty.security.UserAuthentication;
import ai.h2o.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import ai.h2o.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import ai.h2o.org.eclipse.jetty.server.Authentication;
import ai.h2o.org.eclipse.jetty.server.UserIdentity;
import ai.h2o.org.eclipse.jetty.util.B64Code;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthenticator
extends LoginAuthenticator {
    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request2 = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request2.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            String method;
            int space;
            if (!mandatory) {
                return new DeferredAuthentication(this);
            }
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
                String password;
                String username;
                UserIdentity user;
                credentials = credentials.substring(space + 1);
                int i2 = (credentials = B64Code.decode(credentials, StandardCharsets.ISO_8859_1)).indexOf(58);
                if (i2 > 0 && (user = this.login(username = credentials.substring(0, i2), password = credentials.substring(i2 + 1), request2)) != null) {
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (DeferredAuthentication.isDeferred(response)) {
                return Authentication.UNAUTHENTICATED;
            }
            response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "basic realm=\"" + this._loginService.getName() + '\"');
            response.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e2) {
            throw new ServerAuthException(e2);
        }
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

