/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.security.authentication;

import ai.h2o.org.eclipse.jetty.security.Authenticator;
import ai.h2o.org.eclipse.jetty.security.IdentityService;
import ai.h2o.org.eclipse.jetty.security.LoginService;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.server.Response;
import ai.h2o.org.eclipse.jetty.server.UserIdentity;
import ai.h2o.org.eclipse.jetty.server.session.Session;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = Log.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request2) {
    }

    public UserIdentity login(String username, Object password, ServletRequest request2) {
        UserIdentity user = this._loginService.login(username, password, request2);
        if (user != null) {
            this.renewSession((HttpServletRequest)request2, request2 instanceof Request ? ((Request)request2).getResponse() : null);
            return user;
        }
        return null;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request2, HttpServletResponse response) {
        HttpSession httpSession = request2.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("ai.h2o.org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session) {
                        Session s2 = (Session)httpSession;
                        String oldId = s2.getId();
                        s2.renewId(request2);
                        s2.setAttribute("ai.h2o.org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
                        if (s2.isIdChanged() && response != null && response instanceof Response) {
                            ((Response)response).addCookie(s2.getSessionHandler().getSessionCookie(s2, request2.getContextPath(), request2.isSecure()));
                        }
                        LOG.debug("renew {}->{}", oldId, s2.getId());
                    } else {
                        LOG.warn("Unable to renew session " + httpSession, new Object[0]);
                    }
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

