/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server;

import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.http.pathmap.PathMappings;
import ai.h2o.org.eclipse.jetty.server.Authentication;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.server.RequestLog;
import ai.h2o.org.eclipse.jetty.server.Response;
import ai.h2o.org.eclipse.jetty.util.DateCache;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedAttribute;
import ai.h2o.org.eclipse.jetty.util.component.AbstractLifeCycle;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.Cookie;

public abstract class AbstractNCSARequestLog
extends AbstractLifeCycle
implements RequestLog {
    protected static final Logger LOG = Log.getLogger(AbstractNCSARequestLog.class);
    private static ThreadLocal<StringBuilder> _buffers = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(256);
        }
    };
    private String[] _ignorePaths;
    private boolean _extended;
    private transient PathMappings<String> _ignorePathMap;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private boolean _preferProxiedForAddress;
    private transient DateCache _logDateCache;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";

    protected abstract boolean isEnabled();

    public abstract void write(String var1) throws IOException;

    private void append(StringBuilder buf, String s2) {
        if (s2 == null || s2.length() == 0) {
            buf.append('-');
        } else {
            buf.append(s2);
        }
    }

    @Override
    public void log(Request request2, Response response) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request2.getRequestURI()) != null) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            StringBuilder buf = _buffers.get();
            buf.setLength(0);
            if (this._logServer) {
                this.append(buf, request2.getServerName());
                buf.append(' ');
            }
            String addr = null;
            if (this._preferProxiedForAddress) {
                addr = request2.getHeader(HttpHeader.X_FORWARDED_FOR.toString());
            }
            if (addr == null) {
                addr = request2.getRemoteAddr();
            }
            buf.append(addr);
            buf.append(" - ");
            String auth = this.getAuthentication(request2);
            this.append(buf, auth == null ? "-" : auth);
            buf.append(" [");
            if (this._logDateCache != null) {
                buf.append(this._logDateCache.format(request2.getTimeStamp()));
            } else {
                buf.append(request2.getTimeStamp());
            }
            buf.append("] \"");
            this.append(buf, request2.getMethod());
            buf.append(' ');
            this.append(buf, request2.getOriginalURI());
            buf.append(' ');
            this.append(buf, request2.getProtocol());
            buf.append("\" ");
            int status = response.getCommittedMetaData().getStatus();
            if (status >= 0) {
                buf.append((char)(48 + status / 100 % 10));
                buf.append((char)(48 + status / 10 % 10));
                buf.append((char)(48 + status % 10));
            } else {
                buf.append(status);
            }
            long written = response.getHttpChannel().getBytesWritten();
            if (written >= 0L) {
                buf.append(' ');
                if (written > 99999L) {
                    buf.append(written);
                } else {
                    if (written > 9999L) {
                        buf.append((char)(48L + written / 10000L % 10L));
                    }
                    if (written > 999L) {
                        buf.append((char)(48L + written / 1000L % 10L));
                    }
                    if (written > 99L) {
                        buf.append((char)(48L + written / 100L % 10L));
                    }
                    if (written > 9L) {
                        buf.append((char)(48L + written / 10L % 10L));
                    }
                    buf.append((char)(48L + written % 10L));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            if (this._extended) {
                this.logExtended(buf, request2, response);
            }
            if (this._logCookies) {
                Cookie[] cookies = request2.getCookies();
                if (cookies == null || cookies.length == 0) {
                    buf.append(" -");
                } else {
                    buf.append(" \"");
                    for (int i2 = 0; i2 < cookies.length; ++i2) {
                        if (i2 != 0) {
                            buf.append(';');
                        }
                        buf.append(cookies[i2].getName());
                        buf.append('=');
                        buf.append(cookies[i2].getValue());
                    }
                    buf.append('\"');
                }
            }
            if (this._logLatency) {
                long now = System.currentTimeMillis();
                if (this._logLatency) {
                    buf.append(' ');
                    buf.append(now - request2.getTimeStamp());
                }
            }
            String log = buf.toString();
            this.write(log);
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    protected String getAuthentication(Request request2) {
        Authentication authentication = request2.getAuthentication();
        if (authentication instanceof Authentication.User) {
            return ((Authentication.User)authentication).getUserIdentity().getUserPrincipal().getName();
        }
        return null;
    }

    protected void logExtended(StringBuilder b2, Request request2, Response response) throws IOException {
        String referer = request2.getHeader(HttpHeader.REFERER.toString());
        if (referer == null) {
            b2.append("\"-\" ");
        } else {
            b2.append('\"');
            b2.append(referer);
            b2.append("\" ");
        }
        String agent = request2.getHeader(HttpHeader.USER_AGENT.toString());
        if (agent == null) {
            b2.append("\"-\"");
        } else {
            b2.append('\"');
            b2.append(agent);
            b2.append('\"');
        }
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean logCookies) {
        this._logCookies = logCookies;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public void setLogServer(boolean logServer) {
        this._logServer = logServer;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    public void setLogLatency(boolean logLatency) {
        this._logLatency = logLatency;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    @Deprecated
    public void setLogDispatch(boolean value) {
    }

    @Deprecated
    public boolean isLogDispatch() {
        return false;
    }

    public void setPreferProxiedForAddress(boolean preferProxiedForAddress) {
        this._preferProxiedForAddress = preferProxiedForAddress;
    }

    public boolean getPreferProxiedForAddress() {
        return this._preferProxiedForAddress;
    }

    public void setExtended(boolean extended) {
        this._extended = extended;
    }

    @ManagedAttribute(value="use extended NCSA format")
    public boolean isExtended() {
        return this._extended;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale, this._logTimeZone);
        }
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMappings();
            for (int i2 = 0; i2 < this._ignorePaths.length; ++i2) {
                this._ignorePathMap.put(this._ignorePaths[i2], this._ignorePaths[i2]);
            }
        } else {
            this._ignorePathMap = null;
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._logDateCache = null;
        super.doStop();
    }

    public void setLogDateFormat(String format) {
        this._logDateFormat = format;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogLocale(Locale logLocale) {
        this._logLocale = logLocale;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    public void setLogTimeZone(String tz) {
        this._logTimeZone = tz;
    }

    @ManagedAttribute(value="the timezone")
    public String getLogTimeZone() {
        return this._logTimeZone;
    }
}

