/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server;

import ai.h2o.org.eclipse.jetty.io.Connection;
import ai.h2o.org.eclipse.jetty.server.AbstractConnector;
import ai.h2o.org.eclipse.jetty.server.Connector;
import ai.h2o.org.eclipse.jetty.server.Server;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedAttribute;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedObject;
import ai.h2o.org.eclipse.jetty.util.component.AbstractLifeCycle;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.util.ArrayList;
import java.util.List;

@ManagedObject
public class ConnectionLimit
extends AbstractLifeCycle
implements Connection.Listener {
    private static final Logger LOG = Log.getLogger(ConnectionLimit.class);
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private int _connections;
    private int _maxConnections;
    private boolean _accepting = true;

    public ConnectionLimit(int maxConnections, Server server) {
        this._maxConnections = maxConnections;
        this._server = server;
    }

    public ConnectionLimit(int maxConnections, Connector ... connectors) {
        this._maxConnections = maxConnections;
        this._server = null;
        for (Connector c2 : connectors) {
            if (c2 instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c2);
                continue;
            }
            LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", c2);
        }
    }

    @ManagedAttribute(value="The maximum number of connections allowed")
    public synchronized int getMaxConnections() {
        return this._maxConnections;
    }

    public synchronized void setMaxConnections(int max) {
        this._maxConnections = max;
    }

    @ManagedAttribute(value="The current number of connections ")
    public synchronized int getConnections() {
        return this._connections;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this._server != null) {
            for (Connector c2 : this._server.getConnectors()) {
                if (c2 instanceof AbstractConnector) {
                    this._connectors.add((AbstractConnector)c2);
                    continue;
                }
                LOG.warn("Connector {} is not an AbstractConnection. Connections not limited", c2);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ConnectionLimit {} for {}", this._maxConnections, this._connectors);
        }
        this._connections = 0;
        this._accepting = true;
        for (AbstractConnector c3 : this._connectors) {
            c3.addBean(this);
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        for (AbstractConnector c2 : this._connectors) {
            c2.removeBean(this);
        }
        this._connections = 0;
        if (this._server != null) {
            this._connectors.clear();
        }
    }

    @Override
    public synchronized void onOpened(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {} < {} {}", this._connections, this._maxConnections, connection);
        }
        if (++this._connections >= this._maxConnections && this._accepting) {
            this._accepting = false;
            LOG.info("Connection Limit({}) reached for {}", this._maxConnections, this._connectors);
            for (AbstractConnector c2 : this._connectors) {
                c2.setAccepting(false);
            }
        }
    }

    @Override
    public synchronized void onClosed(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClosed {} < {} {}", this._connections, this._maxConnections, connection);
        }
        if (--this._connections < this._maxConnections && !this._accepting) {
            this._accepting = true;
            LOG.info("Connection Limit({}) cleared for {}", this._maxConnections, this._connectors);
            for (AbstractConnector c2 : this._connectors) {
                c2.setAccepting(true);
            }
        }
    }
}

