/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server;

import ai.h2o.org.eclipse.jetty.server.HttpOutput;
import ai.h2o.org.eclipse.jetty.server.HttpWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class EncodingHttpWriter
extends HttpWriter {
    final Writer _converter;

    public EncodingHttpWriter(HttpOutput out, String encoding) {
        super(out);
        try {
            this._converter = new OutputStreamWriter((OutputStream)this._bytes, encoding);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void write(char[] s2, int offset, int length) throws IOException {
        HttpOutput out = this._out;
        if (length == 0 && out.isAllContentWritten()) {
            out.close();
            return;
        }
        while (length > 0) {
            this._bytes.reset();
            int chars = length > 512 ? 512 : length;
            this._converter.write(s2, offset, chars);
            this._converter.flush();
            this._bytes.writeTo(out);
            length -= chars;
            offset += chars;
        }
    }
}

