/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server;

import ai.h2o.org.eclipse.jetty.http.HttpVersion;
import ai.h2o.org.eclipse.jetty.io.AbstractConnection;
import ai.h2o.org.eclipse.jetty.io.Connection;
import ai.h2o.org.eclipse.jetty.io.EndPoint;
import ai.h2o.org.eclipse.jetty.io.ssl.SslConnection;
import ai.h2o.org.eclipse.jetty.server.AbstractConnectionFactory;
import ai.h2o.org.eclipse.jetty.server.ConnectionFactory;
import ai.h2o.org.eclipse.jetty.server.Connector;
import ai.h2o.org.eclipse.jetty.server.SslConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;

public abstract class NegotiatingServerConnectionFactory
extends AbstractConnectionFactory {
    private final List<String> negotiatedProtocols = new ArrayList<String>();
    private String defaultProtocol;

    public NegotiatingServerConnectionFactory(String protocol, String ... negotiatedProtocols) {
        super(protocol);
        if (negotiatedProtocols != null) {
            for (String p2 : negotiatedProtocols) {
                if ((p2 = p2.trim()).isEmpty()) continue;
                this.negotiatedProtocols.add(p2);
            }
        }
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        String dft = defaultProtocol == null ? "" : defaultProtocol.trim();
        this.defaultProtocol = dft.isEmpty() ? null : dft;
    }

    public List<String> getNegotiatedProtocols() {
        return this.negotiatedProtocols;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        String dft;
        List<String> negotiated = this.negotiatedProtocols;
        if (negotiated.isEmpty()) {
            negotiated = connector.getProtocols().stream().filter(p2 -> {
                ConnectionFactory f2 = connector.getConnectionFactory((String)p2);
                return !(f2 instanceof SslConnectionFactory) && !(f2 instanceof NegotiatingServerConnectionFactory);
            }).collect(Collectors.toList());
        }
        if ((dft = this.defaultProtocol) == null && !negotiated.isEmpty()) {
            dft = negotiated.stream().filter(HttpVersion.HTTP_1_1::is).findFirst().orElse(negotiated.get(0));
        }
        SSLEngine engine = null;
        EndPoint ep = endPoint;
        while (engine == null && ep != null) {
            if (ep instanceof SslConnection.DecryptedEndPoint) {
                engine = ((SslConnection.DecryptedEndPoint)ep).getSslConnection().getSSLEngine();
                continue;
            }
            ep = null;
        }
        return this.configure(this.newServerConnection(connector, endPoint, engine, negotiated, dft), connector, endPoint);
    }

    protected abstract AbstractConnection newServerConnection(Connector var1, EndPoint var2, SSLEngine var3, List<String> var4, String var5);

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols(), this.getDefaultProtocol(), this.getNegotiatedProtocols());
    }
}

