/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server.handler;

import ai.h2o.org.eclipse.jetty.server.handler.ContextHandler;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.util.resource.PathResource;
import ai.h2o.org.eclipse.jetty.util.resource.Resource;
import java.nio.file.Files;
import java.nio.file.Path;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowSymLinkAliasChecker.class);

    @Override
    public boolean check(String uri, Resource resource) {
        if (!(resource instanceof PathResource)) {
            return false;
        }
        PathResource pathResource = (PathResource)resource;
        try {
            Path path = pathResource.getPath();
            Path alias2 = pathResource.getAliasPath();
            if (path.equals(alias2)) {
                return false;
            }
            if (this.hasSymbolicLink(path) && Files.isSameFile(path, alias2)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow symlink {} --> {}", resource, pathResource.getAliasPath());
                }
                return true;
            }
        }
        catch (Exception e2) {
            LOG.ignore(e2);
        }
        return false;
    }

    private boolean hasSymbolicLink(Path path) {
        if (Files.isSymbolicLink(path)) {
            return true;
        }
        Path base = path.getRoot();
        for (Path segment : path) {
            if (!Files.isSymbolicLink(base = base.resolve(segment))) continue;
            return true;
        }
        return false;
    }
}

