/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.server.handler;

import ai.h2o.org.eclipse.jetty.http.HttpHeader;
import ai.h2o.org.eclipse.jetty.server.HandlerContainer;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.server.handler.AbstractHandler;
import ai.h2o.org.eclipse.jetty.server.handler.ContextHandler;
import ai.h2o.org.eclipse.jetty.util.URIUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MovedContextHandler
extends ContextHandler {
    final Redirector _redirector;
    String _newContextURL;
    boolean _discardPathInfo;
    boolean _discardQuery;
    boolean _permanent;
    String _expires;

    public MovedContextHandler() {
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
        this.setAllowNullPathInfo(true);
    }

    public MovedContextHandler(HandlerContainer parent, String contextPath, String newContextURL) {
        super(parent, contextPath);
        this._newContextURL = newContextURL;
        this._redirector = new Redirector();
        this.setHandler(this._redirector);
    }

    public boolean isDiscardPathInfo() {
        return this._discardPathInfo;
    }

    public void setDiscardPathInfo(boolean discardPathInfo) {
        this._discardPathInfo = discardPathInfo;
    }

    public String getNewContextURL() {
        return this._newContextURL;
    }

    public void setNewContextURL(String newContextURL) {
        this._newContextURL = newContextURL;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public void setPermanent(boolean permanent) {
        this._permanent = permanent;
    }

    public boolean isDiscardQuery() {
        return this._discardQuery;
    }

    public void setDiscardQuery(boolean discardQuery) {
        this._discardQuery = discardQuery;
    }

    public String getExpires() {
        return this._expires;
    }

    public void setExpires(String expires) {
        this._expires = expires;
    }

    private class Redirector
    extends AbstractHandler {
        private Redirector() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
            if (MovedContextHandler.this._newContextURL == null) {
                return;
            }
            String path = MovedContextHandler.this._newContextURL;
            if (!MovedContextHandler.this._discardPathInfo && request2.getPathInfo() != null) {
                path = URIUtil.addPaths(path, request2.getPathInfo());
            }
            StringBuilder location = URIUtil.hasScheme(path) ? new StringBuilder() : baseRequest.getRootURL();
            location.append(path);
            if (!MovedContextHandler.this._discardQuery && request2.getQueryString() != null) {
                location.append('?');
                String q2 = request2.getQueryString();
                q2 = q2.replaceAll("\r\n?&=", "!");
                location.append(q2);
            }
            response.setHeader(HttpHeader.LOCATION.asString(), location.toString());
            if (MovedContextHandler.this._expires != null) {
                response.setHeader(HttpHeader.EXPIRES.asString(), MovedContextHandler.this._expires);
            }
            response.setStatus(MovedContextHandler.this._permanent ? 301 : 302);
            response.setContentLength(0);
            baseRequest.setHandled(true);
        }
    }
}

