/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.servlets;

import ai.h2o.org.eclipse.jetty.http.HttpMethod;
import ai.h2o.org.eclipse.jetty.util.IO;
import ai.h2o.org.eclipse.jetty.util.MultiMap;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.UrlEncoded;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CGI
extends HttpServlet {
    private static final long serialVersionUID = -6182088932884791074L;
    private static final Logger LOG = Log.getLogger(CGI.class);
    private boolean _ok;
    private File _docRoot;
    private boolean _cgiBinProvided;
    private String _path;
    private String _cmdPrefix;
    private boolean _useFullPath;
    private EnvList _env;
    private boolean _ignoreExitState;
    private boolean _relative;

    @Override
    public void init() throws ServletException {
        String os2;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        this._useFullPath = Boolean.parseBoolean(this.getInitParameter("useFullPath"));
        this._relative = Boolean.parseBoolean(this.getInitParameter("cgibinResourceBaseIsRelative"));
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp != null) {
            this._cgiBinProvided = true;
        } else {
            tmp = this.getInitParameter("resourceBase");
            if (tmp != null) {
                this._cgiBinProvided = true;
            } else {
                tmp = this.getServletContext().getRealPath("/");
            }
        }
        if (this._relative && this._cgiBinProvided) {
            tmp = this.getServletContext().getRealPath(tmp);
        }
        if (tmp == null) {
            LOG.warn("CGI: no CGI bin !", new Object[0]);
            return;
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            LOG.warn("CGI: CGI bin does not exist - " + dir, new Object[0]);
            return;
        }
        if (!dir.canRead()) {
            LOG.warn("CGI: CGI bin is not readable - " + dir, new Object[0]);
            return;
        }
        if (!dir.isDirectory()) {
            LOG.warn("CGI: CGI bin is not a directory - " + dir, new Object[0]);
            return;
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e2) {
            LOG.warn("CGI: CGI bin failed - " + dir, e2);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration<String> e3 = this.getInitParameterNames();
        while (e3.hasMoreElements()) {
            String n2 = e3.nextElement();
            if (n2 == null || !n2.startsWith("ENV_")) continue;
            this._env.set(n2.substring(4), this.getInitParameter(n2));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (os2 = System.getProperty("os.name")) != null && os2.toLowerCase(Locale.ENGLISH).contains("windows")) {
            this._env.set("SystemRoot", "C:\\WINDOWS");
        }
        this._ok = true;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this._ok) {
            res.sendError(503);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: ContextPath : " + req.getContextPath(), new Object[0]);
            LOG.debug("CGI: ServletPath : " + req.getServletPath(), new Object[0]);
            LOG.debug("CGI: PathInfo    : " + req.getPathInfo(), new Object[0]);
            LOG.debug("CGI: _docRoot    : " + this._docRoot, new Object[0]);
            LOG.debug("CGI: _path       : " + this._path, new Object[0]);
            LOG.debug("CGI: _ignoreExitState: " + this._ignoreExitState, new Object[0]);
        }
        String pathInContext = (this._relative ? "" : StringUtil.nonNull(req.getServletPath())) + StringUtil.nonNull(req.getPathInfo());
        File execCmd = new File(this._docRoot, pathInContext);
        String pathInfo = pathInContext;
        if (!this._useFullPath) {
            String path = pathInContext;
            String info = "";
            while ((path.endsWith("/") || !execCmd.exists()) && path.length() >= 0) {
                int index = path.lastIndexOf(47);
                path = path.substring(0, index);
                info = pathInContext.substring(index, pathInContext.length());
                execCmd = new File(this._docRoot, path);
            }
            if (path.length() == 0 || !execCmd.exists() || execCmd.isDirectory() || !execCmd.getCanonicalPath().equals(execCmd.getAbsolutePath())) {
                res.sendError(404);
            }
            pathInfo = info;
        }
        this.exec(execCmd, pathInfo, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String absolutePath;
        String scriptName;
        String scriptPath;
        String pathTranslated;
        assert (req != null);
        assert (res != null);
        assert (pathInfo != null);
        assert (command != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: script is " + command, new Object[0]);
            LOG.debug("CGI: pathInfo is " + pathInfo, new Object[0]);
        }
        String bodyFormEncoded = null;
        if ((HttpMethod.POST.is(req.getMethod()) || HttpMethod.PUT.is(req.getMethod())) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
            MultiMap<String> parameterMap = new MultiMap<String>();
            Enumeration<String> names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String parameterName = names.nextElement();
                parameterMap.addValues(parameterName, (String[])req.getParameterValues(parameterName));
            }
            bodyFormEncoded = UrlEncoded.encode(parameterMap, Charset.forName(req.getCharacterEncoding()), true);
        }
        EnvList env = new EnvList(this._env);
        env.set("AUTH_TYPE", req.getAuthType());
        int contentLen = req.getContentLength();
        if (contentLen < 0) {
            contentLen = 0;
        }
        if (bodyFormEncoded != null) {
            env.set("CONTENT_LENGTH", Integer.toString(bodyFormEncoded.length()));
        } else {
            env.set("CONTENT_LENGTH", Integer.toString(contentLen));
        }
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        if (pathInfo.length() > 0) {
            env.set("PATH_INFO", pathInfo);
        }
        if ((pathTranslated = req.getPathTranslated()) == null || pathTranslated.length() == 0) {
            pathTranslated = pathInfo;
        }
        env.set("PATH_TRANSLATED", pathTranslated);
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("REMOTE_USER", req.getRemoteUser());
        env.set("REQUEST_METHOD", req.getMethod());
        if (this._cgiBinProvided) {
            scriptPath = command.getAbsolutePath();
            scriptName = scriptPath.substring(this._docRoot.getAbsolutePath().length());
        } else {
            String requestURI = req.getRequestURI();
            scriptName = requestURI.substring(0, requestURI.length() - pathInfo.length());
            scriptPath = this.getServletContext().getRealPath(scriptName);
        }
        env.set("SCRIPT_FILENAME", scriptPath);
        env.set("SCRIPT_NAME", scriptName);
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration<String> enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement();
            if (name.equalsIgnoreCase("Proxy")) continue;
            String value = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase(Locale.ENGLISH).replace('-', '_'), value);
        }
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        String execCmd = absolutePath = command.getAbsolutePath();
        if (execCmd.length() > 0 && execCmd.charAt(0) != '\"' && execCmd.contains(" ")) {
            execCmd = "\"" + execCmd + "\"";
        }
        if (this._cmdPrefix != null) {
            execCmd = this._cmdPrefix + " " + execCmd;
        }
        LOG.debug("Environment: " + env.getExportString(), new Object[0]);
        LOG.debug("Command: " + execCmd, new Object[0]);
        final Process p2 = Runtime.getRuntime().exec(execCmd, env.getEnvArray(), this._docRoot);
        if (bodyFormEncoded != null) {
            CGI.writeProcessInput(p2, bodyFormEncoded);
        } else if (contentLen > 0) {
            CGI.writeProcessInput(p2, req.getInputStream(), contentLen);
        }
        OutputStream os2 = null;
        AsyncContext async = req.startAsync();
        try {
            int exitValue;
            async.start(new Runnable(){

                @Override
                public void run() {
                    try {
                        IO.copy(p2.getErrorStream(), System.err);
                    }
                    catch (IOException e2) {
                        LOG.warn(e2);
                    }
                }
            });
            String line = null;
            InputStream inFromCgi = p2.getInputStream();
            while ((line = CGI.getTextLineFromStream(inFromCgi)).length() > 0) {
                int k2;
                if (line.startsWith("HTTP") || (k2 = line.indexOf(58)) <= 0) continue;
                String key = line.substring(0, k2).trim();
                String value = line.substring(k2 + 1).trim();
                if ("Location".equals(key)) {
                    res.sendRedirect(res.encodeRedirectURL(value));
                    continue;
                }
                if ("Status".equals(key)) {
                    String[] token = value.split(" ");
                    int status = Integer.parseInt(token[0]);
                    res.setStatus(status);
                    continue;
                }
                res.addHeader(key, value);
            }
            os2 = res.getOutputStream();
            IO.copy(inFromCgi, os2);
            p2.waitFor();
            if (!this._ignoreExitState && 0 != (exitValue = p2.exitValue())) {
                LOG.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + absolutePath, new Object[0]);
                if (!res.isCommitted()) {
                    res.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException e2) {
            LOG.debug("CGI: Client closed connection!", e2);
        }
        catch (InterruptedException ie) {
            LOG.debug("CGI: interrupted!", new Object[0]);
        }
        finally {
            if (os2 != null) {
                try {
                    os2.close();
                }
                catch (Exception e3) {
                    LOG.debug(e3);
                }
            }
            p2.destroy();
            async.complete();
        }
    }

    private static void writeProcessInput(final Process p2, final String input) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try (OutputStreamWriter outToCgi = new OutputStreamWriter(p2.getOutputStream());){
                    outToCgi.write(input);
                }
                catch (IOException e2) {
                    LOG.debug(e2);
                }
            }
        }).start();
    }

    private static void writeProcessInput(final Process p2, final InputStream input, final int len) {
        if (len <= 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutputStream outToCgi = p2.getOutputStream();
                    IO.copy(input, outToCgi, (long)len);
                    outToCgi.close();
                }
                catch (IOException e2) {
                    LOG.debug(e2);
                }
            }
        }).start();
    }

    private static String getTextLineFromStream(InputStream is) throws IOException {
        int b2;
        StringBuilder buffer = new StringBuilder();
        while ((b2 = is.read()) != -1 && b2 != 10) {
            buffer.append((char)b2);
        }
        return buffer.toString().trim();
    }

    private static class EnvList {
        private Map<String, String> envMap;

        EnvList() {
            this.envMap = new HashMap<String, String>();
        }

        EnvList(EnvList l2) {
            this.envMap = new HashMap<String, String>(l2.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull(value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String getExportString() {
            StringBuilder sb = new StringBuilder();
            for (String variable : this.getEnvArray()) {
                sb.append("export \"");
                sb.append(variable);
                sb.append("\"; ");
            }
            return sb.toString();
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

