/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.servlets;

import ai.h2o.org.eclipse.jetty.servlets.EventSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class EventSourceServlet
extends HttpServlet {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] EVENT_FIELD = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA_FIELD = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMENT_FIELD = ": ".getBytes(StandardCharsets.UTF_8);
    private ScheduledExecutorService scheduler;
    private int heartBeatPeriod = 10;

    @Override
    public void init() throws ServletException {
        String heartBeatPeriodParam = this.getServletConfig().getInitParameter("heartBeatPeriod");
        if (heartBeatPeriodParam != null) {
            this.heartBeatPeriod = Integer.parseInt(heartBeatPeriodParam);
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    @Override
    protected void doGet(HttpServletRequest request2, HttpServletResponse response) throws ServletException, IOException {
        Enumeration<String> acceptValues = request2.getHeaders("Accept");
        while (acceptValues.hasMoreElements()) {
            String accept = acceptValues.nextElement();
            if (!accept.equals("text/event-stream")) continue;
            EventSource eventSource = this.newEventSource(request2);
            if (eventSource == null) {
                response.sendError(503);
            } else {
                this.respond(request2, response);
                AsyncContext async = request2.startAsync();
                async.setTimeout(0L);
                EventSourceEmitter emitter = new EventSourceEmitter(eventSource, async);
                emitter.scheduleHeartBeat();
                this.open(eventSource, emitter);
            }
            return;
        }
        super.doGet(request2, response);
    }

    protected abstract EventSource newEventSource(HttpServletRequest var1);

    protected void respond(HttpServletRequest request2, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("text/event-stream");
        response.addHeader("Connection", "close");
        response.flushBuffer();
    }

    protected void open(EventSource eventSource, EventSource.Emitter emitter) throws IOException {
        eventSource.onOpen(emitter);
    }

    protected class EventSourceEmitter
    implements EventSource.Emitter,
    Runnable {
        private final EventSource eventSource;
        private final AsyncContext async;
        private final ServletOutputStream output;
        private Future<?> heartBeat;
        private boolean closed;

        public EventSourceEmitter(EventSource eventSource, AsyncContext async) throws IOException {
            this.eventSource = eventSource;
            this.async = async;
            this.output = async.getResponse().getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event(String name, String data) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.output.write(EVENT_FIELD);
                this.output.write(name.getBytes(StandardCharsets.UTF_8));
                this.output.write(CRLF);
                this.data(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void data(String data) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(data));
                while ((line = reader.readLine()) != null) {
                    this.output.write(DATA_FIELD);
                    this.output.write(line.getBytes(StandardCharsets.UTF_8));
                    this.output.write(CRLF);
                }
                this.output.write(CRLF);
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void comment(String comment) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.output.write(COMMENT_FIELD);
                this.output.write(comment.getBytes(StandardCharsets.UTF_8));
                this.output.write(CRLF);
                this.output.write(CRLF);
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                EventSourceEmitter eventSourceEmitter = this;
                synchronized (eventSourceEmitter) {
                    this.output.write(13);
                    this.flush();
                    this.output.write(10);
                    this.flush();
                }
                this.scheduleHeartBeat();
            }
            catch (IOException x2) {
                this.close();
                this.eventSource.onClose();
            }
        }

        protected void flush() throws IOException {
            this.async.getResponse().flushBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.closed = true;
                this.heartBeat.cancel(false);
            }
            this.async.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleHeartBeat() {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                if (!this.closed) {
                    this.heartBeat = EventSourceServlet.this.scheduler.schedule(this, (long)EventSourceServlet.this.heartBeatPeriod, TimeUnit.SECONDS);
                }
            }
        }
    }
}

